<?php

namespace App\Exports;

use App\Models\BrandRequirement;
use Illuminate\Http\Request;
use Carbon\Carbon;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class OpportunitiesExport implements FromCollection, WithHeadings
{
    protected $request;

    public function __construct(Request $request)
    {
        $this->request = $request;
    }

    public function collection()
    {
        $query = BrandRequirement::with(['brand','city','market']);

        if ($this->request->filled('cities')) {
            $query->whereIn('city_id', $this->request->cities);
        }

        if ($this->request->filled('markets')) {
            $query->whereIn('market_id', $this->request->markets);
        }

        if ($this->request->date_filter === 'today') {
            $query->whereDate('created_at', Carbon::today());
        }

        if ($this->request->date_filter === 'yesterday') {
            $query->whereDate('created_at', Carbon::yesterday());
        }

        if ($this->request->filled('date_from') && $this->request->filled('date_to')) {
            $query->whereBetween('created_at', [
                Carbon::parse($this->request->date_from)->startOfDay(),
                Carbon::parse($this->request->date_to)->endOfDay()
            ]);
        }

        return $query->get()->map(function ($op) {
            return [
                $op->id,
                $op->brand->name ?? '-',
                $op->city->name ?? '-',
                $op->market->name ?? '-',
                $op->created_at->format('d-m-Y'),
            ];
        });
    }

    public function headings(): array
    {
        return [
            'ID',
            'Brand',
            'City',
            'Market',
            'Created Date'
        ];
    }
}
