<style>
    .modal-body table {
        min-width: 269px;
    }
</style>

<!-- NAVBAR -->
<nav class="navbar navbar-custom">
    <div class="container-fluid d-flex justify-content-between align-items-center">

        <!-- LEFT : BRAND -->
        <a href="/dashboard" style="text-decoration: none;">
            <span class="navbar-brand-custom">
                <i class="fas fa-store"></i> Leasing CRM
            </span>
        </a>

        <!-- RIGHT : ALL BUTTONS IN ONE LINE -->
        <div class="d-flex align-items-center gap-1 flex-nowrap overflow-auto">

            <a href="/inventory" class="btn btn-primary flex-shrink-0">
                📦 Inventory
            </a>

            <a href="/brands" class="btn btn-success flex-shrink-0">
                🏷️ Brand
            </a>

            <a href="/brand-poc" class="btn btn-primary flex-shrink-0">
                👤 Brand POC
            </a>

            <a href="/requirements" class="btn btn-success flex-shrink-0">
                📋 Requirement
            </a>

            <!-- <a href="{{ route('opportunities.index') }}" class="btn btn-primary flex-shrink-0">
                🎯 Opportunities
            </a> -->

            <!-- USER NAME -->
            <!-- <span class="text-white fw-semibold flex-shrink-0 ms-2">
                Hi, {{ auth()->user()->name }}
            </span> -->

            <!-- USERS BUTTON -->
            @if(auth()->user()->role === 'admin')
            <a href="/admin/users" class="btn btn-logout flex-shrink-0">
                <i class="fas fa-users-cog"></i> Users
            </a>
            @endif

            <!-- SETTINGS -->
            <button class="btn btn-logout flex-shrink-0"
                    data-bs-toggle="modal"
                    data-bs-target="#settingsModal">
                <i class="fas fa-cog"></i> Settings
            </button>

            <!-- LOGOUT -->
            <form method="POST" action="/logout" class="flex-shrink-0">
                @csrf
                <button class="btn btn-logout">
                    <i class="fas fa-sign-out-alt"></i> Logout
                </button>
            </form>

        </div>

    </div>
</nav>

<!-- SETTINGS MODAL -->
<div class="modal fade" id="settingsModal" tabindex="-1">
    <div class="modal-dialog modal-xl modal-dialog-centered">
        <div class="modal-content">

            <div class="modal-header">
                <h5><i class="fas fa-sliders-h"></i> Settings</h5>
                <button class="btn-close" data-bs-dismiss="modal"></button>
            </div>

            <div class="modal-body">

                <!-- TABS -->
                <ul class="nav nav-pills mb-3">
                    <li class="nav-item">
                        <a class="nav-link active tab-btn" data-tab="stateTab" href="#">State</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link tab-btn" data-tab="cityTab" href="#">City</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link tab-btn" data-tab="marketTab" href="#">Market</a>
                    </li>
                </ul>

                <!-- STATE TAB -->
                <div id="stateTab" class="tab-section">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="card p-3">
                                <h6>Add State</h6>
                                <input id="state_name" class="form-control" placeholder="State name">
                                <button onclick="addState()" class="btn btn-primary mt-2 w-100">Add State</button>
                            </div>
                        </div>

                        <div class="col-md-8">
                            <div class="card p-3 mt-3">
                                <h6>Existing States</h6>
                                <table class="table table-bordered">
                                    <thead>
                                        <tr><th>SR No.</th><th>State Name</th></tr>
                                    </thead>
                                    <tbody id="stateTable"></tbody>
                                </table>
                                
                            <div id="statePagination" class="mt-2 d-flex justify-content-center"></div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- CITY TAB -->
                <div id="cityTab" class="tab-section d-none">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="card p-3">
                                <h6>Add City</h6>
                                <select id="state_select" class="form-control mb-2"></select>
                                <input id="city_name" class="form-control" placeholder="City name">
                                <button onclick="addCity()" class="btn btn-success mt-2 w-100">Add City</button>
                            </div>
                        </div>

                        <div class="col-md-8">
                            <div class="card p-3 mt-3">
                                <h6>Existing Cities</h6>
                                <table class="table table-bordered">
                                    <thead>
                                        <tr><th>SR No.</th><th>City Name</th></tr>
                                    </thead>
                                    <tbody id="cityTable"></tbody>
                                </table>
                                <div id="cityPagination" class="mt-2 d-flex justify-content-center"></div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- MARKET TAB -->
                <div id="marketTab" class="tab-section d-none">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="card p-3">
                                <h6>Add Market</h6>
                                <select id="city_select" class="form-control mb-2"></select>
                                <input id="market_name" class="form-control" placeholder="Market name">
                                <button onclick="addMarket()" class="btn btn-warning mt-2 w-100">Add Market</button>
                            </div>
                        </div>

                        <div class="col-md-8">
                            <div class="card p-3">
                                <h6>Existing Markets</h6>
                                <table class="table table-bordered">
                                    <thead>
                                        <tr><th>SR No.</th><th>Market Name</th></tr>
                                    </thead>
                                    <tbody id="marketTable"></tbody>
                                </table>
                                <div id="marketPagination" class="mt-2 d-flex justify-content-center"></div>

                            </div>
                        </div>
                    </div>
                </div>

            </div>

            <div class="modal-footer">
                <button class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>

        </div>
    </div>
</div>
<script>
/* ===============================
   GLOBAL REFERENCES
================================ */
const stateTable  = document.getElementById('stateTable');
const cityTable   = document.getElementById('cityTable');
const marketTable = document.getElementById('marketTable');

const stateSelect = document.getElementById('state_select');
const citySelect  = document.getElementById('city_select');

let currentStateId = null;
let currentCityId  = null;

/* ===============================
   COMMON PAGINATION RENDER
================================ */

function renderPagination(res, containerId, callback, extraId = null) {

    // agar ek hi page hai to kuch mat dikhao
    if (res.last_page <= 1) {
        document.getElementById(containerId).innerHTML = '';
        return;
    }

    let prevDisabled = res.current_page === 1 ? 'disabled' : '';
    let nextDisabled = res.current_page === res.last_page ? 'disabled' : '';

    let prevPage = res.current_page - 1;
    let nextPage = res.current_page + 1;

    let html = `
        <div class="d-flex gap-2">
            <button class="btn btn-outline-primary btn-sm"
                ${prevDisabled}
                onclick="${callback}(${extraId ? extraId + ',' : ''}${prevPage})">
                « Previous
            </button>

            <span class="align-self-center fw-semibold">
                Page ${res.current_page} of ${res.last_page}
            </span>

            <button class="btn btn-outline-primary btn-sm"
                ${nextDisabled}
                onclick="${callback}(${extraId ? extraId + ',' : ''}${nextPage})">
                Next »
            </button>
        </div>
    `;

    document.getElementById(containerId).innerHTML = html;
}



/* ======================================================
   🔹 DROPDOWN LOADERS (NO PAGINATION)
====================================================== */
function loadAllStatesDropdown() {
    fetch('/states')
        .then(res => res.json())
        .then(data => {
            let options = '<option value="">Select State</option>';
            data.forEach(s => {
                options += `<option value="${s.id}">${s.name}</option>`;
            });
            stateSelect.innerHTML = options;
        });
}

function loadAllCitiesDropdown(stateId) {
    fetch(`/cities/${stateId}`)
        .then(res => res.json())
        .then(data => {
            let options = '<option value="">Select City</option>';
            data.forEach(c => {
                options += `<option value="${c.id}">${c.name}</option>`;
            });
            citySelect.innerHTML = options;
        });
}

/* ======================================================
   📋 TABLE LOADERS (WITH PAGINATION)
====================================================== */
function loadStates(page = 1) {

    fetch(`/settings/states?page=${page}`)
        .then(res => res.json())
        .then(res => {

            let rows = '';

           res.data.forEach((s, i) => {

    let srNo = res.total - ((res.current_page - 1) * res.per_page) - i;

    rows += `
        <tr>
            <td>${srNo}</td>
            <td>${s.name}</td>
        </tr>`;
});


            stateTable.innerHTML = rows;
            renderPagination(res, 'statePagination', 'loadStates');
        });
}

function loadCities(stateId, page = 1) {

    currentStateId = stateId;

    fetch(`/settings/cities/${stateId}?page=${page}`)
        .then(res => res.json())
        .then(res => {

            let rows = '';

           res.data.forEach((c, i) => {

    let srNo = res.total - ((res.current_page - 1) * res.per_page) - i;

    rows += `
        <tr>
            <td>${srNo}</td>
            <td>${c.name}</td>
        </tr>`;
});


            cityTable.innerHTML = rows;

            renderPagination(
                res,
                'cityPagination',
                'loadCities',
                stateId
            );
        });
}

function loadMarkets(cityId, page = 1) {

    currentCityId = cityId;

    fetch(`/settings/markets/${cityId}?page=${page}`)
        .then(res => res.json())
        .then(res => {

            let rows = '';

         res.data.forEach((m, i) => {

    let srNo = res.total - ((res.current_page - 1) * res.per_page) - i;

    rows += `
        <tr>
            <td>${srNo}</td>
            <td>${m.name}</td>
        </tr>`;
});


            marketTable.innerHTML = rows;

            renderPagination(
                res,
                'marketPagination',
                'loadMarkets',
                cityId
            );
        });
}

/* ===============================
   ADD STATE
================================ */
function addState() {

    let name = document.getElementById('state_name').value.trim();
    if (!name) return alert('State name required');

    fetch('/states', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '{{ csrf_token() }}',
            'Accept': 'application/json'
        },
        body: JSON.stringify({ name })
    })
    .then(async res => {
        if (res.status === 422) {
            let data = await res.json();
            return alert(data.errors.name[0]);
        }
        document.getElementById('state_name').value = '';
        loadStates(1);
        loadAllStatesDropdown(); // 🔥 FIX
    });
}

/* ===============================
   ADD CITY
================================ */
function addCity() {

    if (!stateSelect.value) return alert('Select state');

    let name = document.getElementById('city_name').value.trim();
    if (!name) return alert('City name required');

    fetch('/cities', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '{{ csrf_token() }}',
            'Accept': 'application/json'
        },
        body: JSON.stringify({
            state_id: stateSelect.value,
            name
        })
    })
    .then(async res => {
        if (res.status === 422) {
            let data = await res.json();
            return alert(data.errors.name[0]);
        }
        document.getElementById('city_name').value = '';
        loadCities(stateSelect.value, 1);
        loadAllCitiesDropdown(stateSelect.value); // 🔥 FIX
    });
}

/* ===============================
   ADD MARKET
================================ */
function addMarket() {

    if (!citySelect.value) return alert('Select city');

    let name = document.getElementById('market_name').value.trim();
    if (!name) return alert('Market name required');

    fetch('/markets', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '{{ csrf_token() }}',
            'Accept': 'application/json'
        },
        body: JSON.stringify({
            city_id: citySelect.value,
            name
        })
    })
    .then(async res => {
        if (res.status === 422) {
            let data = await res.json();
            return alert(data.errors.name[0]);
        }
        document.getElementById('market_name').value = '';
        loadMarkets(citySelect.value, 1);
    });
}

/* ===============================
   DROPDOWN CHANGE EVENTS
================================ */
stateSelect.addEventListener('change', function () {
    if (this.value) {
        loadCities(this.value, 1);        // table
        loadAllCitiesDropdown(this.value); // dropdown
        marketTable.innerHTML = '';
        document.getElementById('marketPagination').innerHTML = '';
    }
});

citySelect.addEventListener('change', function () {
    if (this.value) {
        loadMarkets(this.value, 1);
    }
});

/* ===============================
   TAB SWITCH
================================ */
document.querySelectorAll('.tab-btn').forEach(btn => {
    btn.onclick = function (e) {
        e.preventDefault();
        document.querySelectorAll('.tab-btn').forEach(b => b.classList.remove('active'));
        this.classList.add('active');
        document.querySelectorAll('.tab-section').forEach(s => s.classList.add('d-none'));
        document.getElementById(this.dataset.tab).classList.remove('d-none');
    };
});

/* ===============================
   MODAL OPEN
================================ */
document.getElementById('settingsModal')
    .addEventListener('shown.bs.modal', () => {
        loadStates(1);              // 📋 paginated table
        loadAllStatesDropdown();    // ⬇️ full dropdown
    });

</script>