<?php
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\LocationController;
use App\Http\Controllers\InventoryController;
use App\Http\Controllers\BrandController;
use App\Http\Controllers\BrandRequirementController;
use App\Http\Controllers\BrandPocController;

use App\Models\Market;
use App\Http\Controllers\OpportunityController;

 Route::get('/', function () {
    return view('auth.login');
});

Route::get('/login',[AuthController::class,'loginPage'])->name('login');
Route::post('/login',[AuthController::class,'login']);


Route::middleware(['auth'])->group(function () {

    Route::get('/admin/users', [AuthController::class, 'users']);

    Route::post('/admin/users/create', [AuthController::class, 'adminCreateUser']);

    Route::post('/admin/users/{id}/password', [AuthController::class, 'resetPassword']);
    Route::post('/admin/users/{id}/role', [AuthController::class, 'changeRole']);
    Route::delete('/admin/users/{id}', [AuthController::class, 'deleteUser']);

});
Route::post('/logout',[AuthController::class,'logout']);

Route::middleware('auth')->group(function(){


    Route::get('/dashboard', function(){
        return view('dashboard');
    });
});
Route::middleware('auth')->group(function(){
    Route::get('/brands',[BrandController::class,'create']);
    Route::post('/brands',[BrandController::class,'store']);
});


Route::middleware('auth')->group(function(){

    // 🔹 DROPDOWNS (NO PAGINATION)
    Route::get('/states',[LocationController::class,'states']);
    Route::get('/cities/{id}',[LocationController::class,'cities']);
    Route::get('/markets/{id}',[LocationController::class,'markets']);

    // 🔹 ADD (CREATE)
    Route::post('/states', [LocationController::class, 'storeState']);
    Route::post('/cities', [LocationController::class, 'storeCity']);
    Route::post('/markets', [LocationController::class, 'storeMarket']);

    // 🔹 SETTINGS MODAL (PAGINATED LISTS)
    Route::get('/settings/states', [LocationController::class, 'statesPaginated']);
    Route::get('/settings/cities/{state}', [LocationController::class, 'citiesPaginated']);
    Route::get('/settings/markets/{city}', [LocationController::class, 'marketsPaginated']);

});



Route::middleware('auth')->group(function(){

    Route::get('/inventory',[InventoryController::class,'create']);
    Route::post('/inventory',[InventoryController::class,'store']);
    Route::get('/inventory/list', [InventoryController::class, 'list']);
    Route::get('/inventory/{id}', [InventoryController::class, 'show']);

Route::delete('/inventory/{id}', [InventoryController::class, 'destroy']);
Route::get('/inventory/{id}/edit', [InventoryController::class, 'edit']);
Route::put('/inventory/{id}', [InventoryController::class, 'update']); // ✅ REQUIRED

Route::get('/inventory/{id}/data', [InventoryController::class, 'show']); // AJAX


});
Route::get('/brand-poc',[BrandPocController::class,'create']);
Route::post('/brand-poc',[BrandPocController::class,'store']);











Route::get('/brands/list', [BrandController::class,'list']);
Route::get('/brands/{id}', [BrandController::class,'show']);

Route::put('/brands/{id}', [BrandController::class,'update']);
Route::delete('/brands/{id}', [BrandController::class,'destroy']);









Route::get('/brand-poc/list', [BrandPocController::class, 'list']);

Route::get('/brand-poc/{id}', [BrandPocController::class,'show']);
Route::put('/brand-poc/{id}', [BrandPocController::class,'update']);
Route::delete('/brand-poc/{id}', [BrandPocController::class,'destroy']);


Route::middleware('auth')->group(function () {

    Route::get('/requirements', [BrandRequirementController::class,'create']);
    Route::post('/requirements', [BrandRequirementController::class,'store']);

    Route::get('/requirements/list', [BrandRequirementController::class,'list']);
    Route::get('/requirements/{id}', [BrandRequirementController::class,'show']);

    // ✅ FIXED ROUTES
    Route::post('/requirements/{id}/update', [BrandRequirementController::class,'update']);
Route::delete('/requirements/{id}', [BrandRequirementController::class, 'destroy']);


   
});
Route::get(
    '/brands/{brandId}/pocs',
    [BrandPocController::class, 'getByBrand']
);
Route::middleware('auth')->group(function () {

    Route::get('/dashboard', fn () => view('dashboard'));

    Route::get('/opportunities', [OpportunityController::class,'index'])
        ->name('opportunities.index');

    Route::get('/opportunities/{id}', [OpportunityController::class,'show']);


    Route::get('/opportunities/export', 
    [OpportunityController::class, 'export']
)->name('opportunities.export');

});
Route::get('/get-markets', function (Request $request) {
    return Market::whereIn('city_id', $request->cities)->get();
});





Route::middleware(['auth'])->group(function () {
    Route::get('/dashboard', function () {
        return view('dashboard');
    })->name('dashboard');
});
