<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Sign In - Welcome Back</title>

  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">
  <link rel="icon" type="image/png" sizes="48x48" href="https://retailcrm.ixapl.com/image/favicon.ico">

  <style>
    body {
      min-height: 100vh;
      margin: 0;
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      font-family: system-ui, -apple-system, 'Segoe UI', sans-serif;
      display: flex;
      align-items: center;
      justify-content: center;
      color: #1f2937;
    }

    .login-container {
      background: white;
      border-radius: 20px;
      box-shadow: 0 20px 60px rgba(0,0,0,0.28);
      max-width: 860px;
      width: 92%;
      max-height: 92vh;
      overflow: hidden;
      display: flex;
    }

    .login-left {
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      color: white;
      flex: 1;
      padding: 4rem 2.8rem;
      display: flex;
      flex-direction: column;
      justify-content: center;
      align-items: center;
      text-align: center;
    }

    .login-left i {
      font-size: 7rem;
      margin-bottom: 2rem;
      color: #ffde3b;
    }

    .login-left h2 {
      font-size: 2.8rem;
      font-weight: 700;
      margin-bottom: 1.2rem;
    }

    .login-left p {
      font-size: 1.08rem;
      opacity: 0.92;
      line-height: 1.65;
    }

    .login-right {
      flex: 1;
      padding: 4rem 3.2rem;
      overflow-y: auto;
    }

    .login-header {
      margin-bottom: 2.8rem;
    }

    .login-header h3 {
      font-size: 2.25rem;
      font-weight: 700;
      margin-bottom: 0.6rem;
    }

    .login-header p {
      color: #6b7280;
      font-size: 1rem;
    }

    .form-group {
      margin-bottom: 1.9rem;
    }

    .form-group label {
      font-weight: 600;
      font-size: 0.94rem;
      margin-bottom: 0.6rem;
      color: #374151;
      display: block;
    }

    .input-wrapper {
      position: relative;
    }

    .form-control-custom {
      width: 100%;
      padding: 1rem 3rem 1rem 3rem;           /* ← important: space for both icons */
      border: 2px solid #e5e7eb;
      border-radius: 12px;
      font-size: 1.02rem;
      background: #f9fafb;
      transition: all 0.25s ease;
    }

    .form-control-custom:focus {
      border-color: #667eea;
      box-shadow: 0 0 0 4px rgba(102, 126, 234, 0.16);
      background: white;
      outline: none;
    }

    .left-icon {
      position: absolute;
      left: 1.1rem;
      top: 50%;
      transform: translateY(-50%);
      color: #6b7280;
      font-size: 1.2rem;
      pointer-events: none;
    }

    .toggle-password {
      position: absolute;
      right: 1.1rem;
      top: 50%;
      transform: translateY(-50%);
      cursor: pointer;
      color: #6b7280;
      font-size: 1.2rem;
      transition: color 0.2s;
    }

    .toggle-password:hover,
    .toggle-password.active {
      color: #667eea;
    }

    .btn-login {
      width: 100%;
      padding: 1rem;
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      border: none;
      border-radius: 12px;
      color: white;
      font-size: 1.08rem;
      font-weight: 600;
      transition: all 0.3s ease;
      box-shadow: 0 4px 14px rgba(102,126,234,0.25);
    }

    .btn-login:hover {
      transform: translateY(-2px);
      box-shadow: 0 12px 28px rgba(102,126,234,0.38);
    }

    .alert-custom {
      padding: 1rem 1.3rem;
      border-radius: 10px;
      margin-bottom: 2rem;
      background: #fee2e2;
      border-left: 5px solid #dc2626;
      color: #7f1d1d;
      display: flex;
      align-items: center;
      gap: 0.9rem;
    }

    @media (max-width: 992px) {
      .login-container { flex-direction: column; max-width: 520px; }
      .login-left { padding: 3.5rem 2.5rem; }
      .login-right { padding: 3rem 2.5rem; }
    }

    @media (max-width: 576px) {
      .login-left { display: none; }
      .login-right { padding: 2.5rem 1.8rem; }
    }
  </style>
</head>
<body>

<div class="login-container">

  <div class="login-left">
    <i class="fas fa-lock"></i>
    <h2>Welcome Back!</h2>
    <p>Sign in to continue your journey with us</p>
  </div>

  <div class="login-right">

    <div class="login-header">
      <h3>Sign In</h3>
      <p>Please enter your credentials to log in</p>
    </div>

    <?php if(session('error')): ?>
    <div class="alert-custom">
      <i class="fas fa-exclamation-circle"></i>
      <span><?php echo e(session('error')); ?></span>
    </div>
    <?php endif; ?>

    <form method="POST" action="/login">
      <?php echo csrf_field(); ?>

      <!-- Email field -->
      <div class="form-group">
        <label for="email">Email Address</label>
        <div class="input-wrapper">
          <i class="fas fa-envelope left-icon"></i>
          <input type="email" id="email" name="email"
                 class="form-control-custom"
                 placeholder="you@example.com"
                 required autofocus autocomplete="email">
        </div>
      </div>

      <!-- Password field – eye icon INSIDE input -->
      <div class="form-group">
        <label for="password">Password</label>
        <div class="input-wrapper">
          <i class="fas fa-lock left-icon"></i>
          <input type="password" id="password" name="password"
                 class="form-control-custom"
                 placeholder="••••••••"
                 required autocomplete="current-password">
          <i class="fas fa-eye toggle-password" id="togglePassword"></i>
        </div>
      </div>

      <button type="submit" class="btn-login">
        Sign In
      </button>

    </form>

  </div>
</div>

<script>
  const toggleBtn = document.getElementById('togglePassword');
  const passwordField = document.getElementById('password');

  toggleBtn.addEventListener('click', function () {
    // toggle between password ↔ text
    const type = passwordField.type === 'password' ? 'text' : 'password';
    passwordField.type = type;

    // toggle eye ↔ eye-slash icon
    this.classList.toggle('fa-eye');
    this.classList.toggle('fa-eye-slash');
    this.classList.toggle('active');
  });
</script>

</body>
</html><?php /**PATH /home/ixapl/public_html/retailcrm.ixapl.com/resources/views/auth/login.blade.php ENDPATH**/ ?>