<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Brand;


class BrandController extends Controller
{
    public function create(){
        return view('brand.create');
    }

    public function store(Request $r){
        $data = $r->all();
           
            // ✅ multiple values ko string bana do
    if ($r->has('business_model')) {
        $data['business_model'] = implode(',', $r->business_model);
    }
        if($r->deck){
            $data['deck'] = $r->deck->store('brand_decks','public');
        }

        Brand::create($data);
        return back()->with('success','Brand Added');
    } 
   public function list(Request $request)
{
    return Brand::orderBy('id','desc')->paginate(23);
}


    public function show($id)
    {
        return Brand::findOrFail($id);
    }
public function update(Request $request, $id)
{
    $brand = Brand::findOrFail($id);

    $data = $request->except(['_token', '_method']);

    if ($request->has('business_model')) {
        $data['business_model'] = implode(',', $request->business_model);
    }

    if ($request->hasFile('deck')) {
        $data['deck'] = $request->file('deck')->store('brands', 'public');
    }

    $brand->update($data);

    return response()->json([
        'success' => true,
        'message' => 'Brand updated successfully'
    ]);
}


    public function destroy($id)
    {
        Brand::findOrFail($id)->delete();
        return response()->json(['success' => true]);
    }
}
