<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('inventories', function (Blueprint $table) {
    $table->id();
    $table->string('type');
    $table->text('unit_address');
    $table->string('rm_name');

    $table->foreignId('state_id');
    $table->foreignId('city_id');
    $table->foreignId('market_id');

    $table->string('poc_name')->nullable();
    $table->string('mobile')->nullable();
    $table->string('email')->nullable();
    $table->string('designation')->nullable();

    $table->integer('area');
    $table->integer('rate');
    $table->integer('monthly_rent');

    $table->string('floor')->nullable();
    $table->string('frontage')->nullable();
    $table->string('availability');

    $table->string('current_brand')->nullable();
    $table->date('vacant_date')->nullable();

    $table->string('front_view')->nullable();
    $table->string('left_view')->nullable();
    $table->string('right_view')->nullable();
    $table->string('interior_view')->nullable();

    $table->timestamps();
});

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('inventories');
    }
};
