<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Brand;
use App\Models\BrandPoc;

class BrandPocController extends Controller
{
    public function create()    
    {
        return view('brand_poc.create', [
            'brands' => Brand::all()
        ]);
    }

  public function store(Request $request)
{
    $request->validate([
        'brand_id'    => 'required|exists:brands,id',
        'name'        => 'required|string|max:255',
        'designation' => 'required|string|max:255',
        'phone'       => 'required|digits:10',
        'email'       => 'required|email',
        'zone'        => 'required',
    ]);

    // 🔒 DUPLICATE CHECK (same brand + phone)
    $exists = BrandPoc::where('brand_id', $request->brand_id)
        ->where('phone', $request->phone)
        ->exists();

    if ($exists) {
        return back()->with('success', 'This POC already exists');
    }

    BrandPoc::create($request->only([
        'brand_id','name','designation','phone','email','zone'
    ]));

    return back()->with('success', 'POC Added Successfully');
}


   public function list(Request $request)
{
    $pocs = BrandPoc::with('brand')
        ->orderBy('id', 'desc')   // explicit latest
        ->paginate(15);

    return response()->json($pocs);
}



    public function show($id)
    {
        return BrandPoc::with('brand')->findOrFail($id);
    }

  public function update(Request $request, $id)
{
    $request->validate([
        'brand_id'    => 'required|exists:brands,id',
        'name'        => 'required|string|max:255',
        'designation' => 'required|string|max:255',
        'phone'       => 'required|digits:10',
        'email'       => 'required|email',
        'zone'        => 'required',
    ], [
        'brand_id.required' => 'Brand select karna zaroori hai',
        'name.required' => 'Name field blank hai',
        'designation.required' => 'Designation missing hai',
        'phone.required' => 'Phone number required hai',
        'email.required' => 'Email field required hai',
        'zone.required' => 'Zone select nahi kiya gaya',
    ]);

    $poc = BrandPoc::findOrFail($id);

    $poc->update($request->only([
        'brand_id','name','designation','phone','email','zone'
    ]));

    return response()->json(['success' => true]);
}


    public function destroy($id)
    {
        BrandPoc::findOrFail($id)->delete();
        return response()->json(['success' => true]);
    }

 public function getByBrand($brandId)
    {
        return response()->json(
            BrandPoc::where('brand_id', $brandId)->get()
        );
    }

}