<?php

namespace App\Models;
use Illuminate\Database\Eloquent\Model;

class Inventory extends Model
{
    protected $fillable = [
        'type','unit_address','rm_name',
        'state_id','city_id','market_id',
        'poc_name','mobile','email','designation',
        'area','rate','monthly_rent',
        'floor','frontage','availability',
        'current_brand','vacant_date',
        'front_view','left_view','right_view','interior_view'
    ];



    public function state()
    {
        return $this->belongsTo(State::class);
    }

    public function city()
    {
        return $this->belongsTo(City::class);
    }

    public function market()
    {
        return $this->belongsTo(Market::class);
    }


}
