<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Models\Inventory;

class Market extends Model
{
    protected $fillable = ['city_id','name'];

    public function city()
    {
        return $this->belongsTo(City::class);
    }

    // ADD THIS METHOD (MOST IMPORTANT)
    public function inventories()
    {
        return $this->hasMany(Inventory::class, 'market_id');
    }
}