@extends('layouts.app')

@section('content')
<div class="container py-4">

    {{-- HEADER --}}
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h3 class="mb-1 fw-bold">
                <i class="bi bi-people-fill text-primary"></i> User Management
            </h3>
            <p class="text-muted mb-0">Manage system users and permissions</p>
        </div>
        
        @if(auth()->user()->role === 'admin')
        <button type="button" class="btn btn-primary btn-lg shadow-sm" onclick="toggleUserForm()">
            <i class="bi bi-plus-circle me-2"></i>Create New User
        </button>
        @endif
    </div>

    {{-- SUCCESS MESSAGE --}}
    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show shadow-sm" role="alert">
            <i class="bi bi-check-circle-fill me-2"></i>{{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    {{-- ================= ADMIN CREATE USER SECTION ================= --}}
    @if(auth()->user()->role === 'admin')
    <div class="card border-0 shadow-sm mb-4 d-none" id="createUserCard">
        <div class="card-header bg-primary text-white fw-bold">
           <i class="bi bi-person-gear me-2"></i>Create New User
        </div>

        <div class="card-body p-4">
            <form method="POST" action="/admin/users/create" class="row g-3">
                @csrf

                <div class="col-md-3">
                    <label class="form-label fw-semibold">
                           <i class="bi bi-person-lines-fill me-1 text-secondary"></i>Full Name</label>
                    <div class="input-group">
                        <span class="input-group-text"><i class="bi bi-person-fill"></i></span>
                        <input type="text" name="name" class="form-control" placeholder="Enter full name" required>
                    </div>
                </div>

                <div class="col-md-3">
                    <label class="form-label fw-semibold">Email Address</label>
                    <div class="input-group">
                        <span class="input-group-text"><i class="bi bi-envelope"></i></span>
                        <input type="email" name="email" class="form-control" placeholder="Enter email address" required>
                    </div>
                </div>

                <div class="col-md-3">
                    <label class="form-label fw-semibold">Password</label>
                    <div class="input-group">
                        <span class="input-group-text"><i class="bi bi-lock"></i></span>
                        <input type="password" name="password" class="form-control" placeholder="Enter password" required>
                    </div>
                </div>

                <div class="col-md-3">
                    <label class="form-label fw-semibold">👑 Role</label>
                    <select name="role" class="form-select" required>
                        <option value="">⚙️Select Role</option>
                        <option value="admin">👑 Admin</option>
                        <option value="operation">⚙️ Operation</option>
                        <option value="supervisor">👔 Supervisor</option>
                        <option value="sales">💼 Sales</option>
                    </select>
                </div>

           <div class="col-12 text-center mt-3">
    <button type="submit" class="btn btn-success px-5">
        <i class="bi bi-save me-2"></i>Create User
    </button>
</div>


            </form>
        </div>
    </div>
    @endif
    {{-- ================= END ADMIN CREATE USER ================= --}}

    {{-- ================= USERS TABLE ================= --}}
    <div class="card border-0 shadow-sm">
        <div class="card-header bg-light border-0">
            <div class="d-flex justify-content-between align-items-center">
                <h5 class="mb-0 fw-semibold">
                    <i class="bi bi-table me-2"></i>All Users
                </h5>
                <span class="badge bg-primary">{{ $users->total() }} Total Users</span>
            </div>
        </div>
        
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover align-middle mb-0">
                    <thead class="table-light">
                        <tr>
                            <th style="width:80px;" class="text-center">SR.No</th>
                            <th>
                                <i class="bi bi-person-badge me-1"></i>Name
                            </th>
                            <th>
                                <i class="bi bi-envelope me-1"></i>Email
                            </th>
                            <th style="width:180px;">
                                <i class="bi bi-shield-check me-1"></i>Role
                            </th>
                            <th style="width:350px;" class="text-center">
                                <i class="bi bi-tools me-1"></i>Actions
                            </th>
                        </tr>
                    </thead>

                    <tbody>
                    @forelse($users as $u)
                        <tr>
                            <td class="text-center fw-semibold text-muted">
                                {{ $users->total() - (($users->currentPage() - 1) * $users->perPage()) - $loop->index }}
                            </td>

                            <td>
                                <div class="d-flex align-items-center">
                                    <div class="avatar-circle me-2">
                                        {{ strtoupper(substr($u->name, 0, 1)) }}
                                    </div>
                                    <span class="fw-semibold">{{ $u->name }}</span>
                                </div>
                            </td>

                            <td class="text-muted">{{ $u->email }}</td>

                            {{-- ROLE CHANGE --}}
                            <td>
                                <form method="POST" action="/admin/users/{{ $u->id }}/role">
                                    @csrf
                                    <select name="role" class="form-select form-select-sm role-select" onchange="this.form.submit()">
                                        @foreach(['admin','operation','supervisor','sales'] as $r)
                                            <option value="{{ $r }}" {{ $u->role === $r ? 'selected' : '' }}>
                                                @if($r === 'admin') 👑 @elseif($r === 'operation') ⚙️ @elseif($r === 'supervisor') 👔 @else 💼 @endif
                                                {{ ucfirst($r) }}
                                            </option>
                                        @endforeach
                                    </select>
                                </form>
                            </td>

                            {{-- ACTIONS --}}
                            <td>
                                <div class="d-flex gap-2 align-items-start">
                                    {{-- RESET PASSWORD --}}
                                    <div style="flex: 1;">
                                        <form method="POST" action="/admin/users/{{ $u->id }}/password">
                                            @csrf
                                            <div class="input-group input-group-sm mb-0">
                                                <input type="password" name="password" class="form-control" placeholder="New Password" required>
<button class="btn btn-warning" type="submit" title="Reset Password">
   <i class="fas fa-key"></i> Change Password 
</button>

                                            </div>
                                        </form>
                                    </div>

                                    {{-- DELETE USER --}}
                                    <form method="POST" action="/admin/users/{{ $u->id }}" onsubmit="return confirm('⚠️ Are you sure you want to delete this user?')" class="m-0">
                                        @csrf
                                        @method('DELETE')
                                       <button class="btn btn-danger btn-sm d-flex align-items-center"
        type="submit"
        title="Delete User"
        style="height:31px;">
    <i class="fas fa-trash"></i>
</button>

                                    </form>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5" class="text-center py-5">
                                <i class="bi bi-inbox display-1 text-muted d-block mb-3"></i>
                                <p class="text-muted mb-0">No users found</p>
                            </td>
                        </tr>
                    @endforelse
                    </tbody>
                </table>
            </div>
        </div>

        {{-- PAGINATION --}}
        @if($users->hasPages())
        <div class="card-footer bg-light border-0">
            <div class="d-flex justify-content-between align-items-center">
                <small class="text-muted">
                    Showing {{ $users->firstItem() }} to {{ $users->lastItem() }} of {{ $users->total() }} users
                </small>
                {{ $users->links('pagination::simple-bootstrap-5') }}
            </div>
        </div>
        @endif
    </div>

</div>

{{-- ================= STYLES ================= --}}
<style>
    .avatar-circle {
        width: 35px;
        height: 35px;
        border-radius: 50%;
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        display: flex;
        align-items: center;
        justify-content: center;
        font-weight: bold;
        font-size: 14px;
    }

    .card {
        border-radius: 12px;
        overflow: hidden;
    }

    .btn {
        border-radius: 8px;
        transition: all 0.3s ease;
    }

    .btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(0,0,0,0.15);
    }

    .form-control:focus,
    .form-select:focus {
        border-color: #667eea;
        box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.25);
    }

    .table > tbody > tr:hover {
        background-color: #f8f9fa;
    }

    .role-select {
        border-radius: 6px;
        cursor: pointer;
    }

    .input-group-text {
        background-color: #f8f9fa;
        border-right: none;
    }

    .input-group .form-control {
        border-left: none;
    }

    .input-group .form-control:focus {
        border-left: 1px solid #ced4da;
    }

    .alert {
        border-radius: 10px;
        border: none;
    }

    .shadow-sm {
        box-shadow: 0 2px 8px rgba(0,0,0,0.08) !important;
    }
</style>

{{-- ================= SCRIPT ================= --}}
<script>
function toggleUserForm() {
    const card = document.getElementById('createUserCard');
    card.classList.toggle('d-none');
    
    // Smooth scroll to form when opening
    if (!card.classList.contains('d-none')) {
        setTimeout(() => {
            card.scrollIntoView({ behavior: 'smooth', block: 'start' });
        }, 100);
    }
}

// Auto-dismiss success alerts
document.addEventListener('DOMContentLoaded', function() {
    const alerts = document.querySelectorAll('.alert-success');
    alerts.forEach(alert => {
        setTimeout(() => {
            alert.classList.remove('show');
            setTimeout(() => alert.remove(), 150);
        }, 5000);
    });
});
</script>
@endsection