@extends('layouts.app')



@section('title','Brand POC')

@section('content')
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

       
        .page-container {
            max-width: 1190px;
            margin: 0 auto;
        }

        .page-header {
            background: white;
            border-radius: 15px;
            padding: 30px;
            margin-bottom: 30px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
        }

        .page-header h1 {
            color: #333;
            font-size: 2rem;
            font-weight: 700;
            margin: 0;
            display: flex;
            align-items: center;
            gap: 15px;
        }

        .page-header h1 i {
            color: #667eea;
            font-size: 2.2rem;
        }

        .page-header p {
            color: #666;
            margin: 10px 0 0 0;
            font-size: 0.95rem;
        }

        .form-container {
            background: white;
            border-radius: 15px;
            padding: 40px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
        }

        .alert-success-custom {
            padding: 15px 20px;
            border-radius: 10px;
            margin-bottom: 30px;
            border-left: 4px solid #28a745;
            background-color: #d4edda;
            color: #155724;
            display: flex;
            align-items: center;
            animation: slideDown 0.3s ease;
        }

        .alert-success-custom i {
            margin-right: 10px;
            font-size: 1.2rem;
        }

        @keyframes slideDown {
            from {
                opacity: 0;
                transform: translateY(-10px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .form-section {
            margin-bottom: 35px;
        }

        .form-section-title {
            font-size: 1.2rem;
            font-weight: 600;
            color: #333;
            margin-bottom: 20px;
            padding-bottom: 10px;
            border-bottom: 2px solid #f0f0f0;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .form-section-title i {
            color: #667eea;
        }

        .form-group {
            margin-bottom: 25px;
        }

        .form-group label {
            display: block;
            margin-bottom: 8px;
            color: #333;
            font-weight: 600;
            font-size: 0.9rem;
        }

        .form-group label i {
            color: #667eea;
            margin-right: 5px;
            width: 18px;
        }

        .form-group label .required {
            color: #dc3545;
            margin-left: 3px;
        }

        .form-control-custom,
        .form-select-custom {
            width: 100%;
            padding: 14px 15px;
            border: 2px solid #e1e8ed;
            border-radius: 10px;
            font-size: 1rem;
            transition: all 0.3s ease;
            outline: none;
            background: white;
        }

        .form-control-custom:focus,
        .form-select-custom:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        }

        .form-select-custom {
            cursor: pointer;
            appearance: none;
            background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='12' height='12' viewBox='0 0 12 12'%3E%3Cpath fill='%23667eea' d='M6 9L1 4h10z'/%3E%3C/svg%3E");
            background-repeat: no-repeat;
            background-position: right 15px center;
            padding-right: 40px;
        }

        .btn-submit {
            width: 100%;
            padding: 16px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            border-radius: 10px;
            color: white;
            font-size: 1.1rem;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
        }

        .btn-submit:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 25px rgba(102, 126, 234, 0.4);
        }

        .btn-submit i {
            font-size: 1.2rem;
        }

        .form-row {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 20px;
        }

        .info-badge {
            display: inline-block;
            background: #e8f0fe;
            color: #1967d2;
            padding: 4px 10px;
            border-radius: 12px;
            font-size: 0.75rem;
            font-weight: 600;
            margin-left: 8px;
        }

        @media (max-width: 768px) {
            /* body {
                padding: 20px 10px;
            } */

            .page-header {
                padding: 20px;
            }

            .page-header h1 {
                font-size: 1.5rem;
            }

            .page-header h1 i {
                font-size: 1.7rem;
            }

            .form-container {
                padding: 25px 20px;
            }

            .form-row {
                grid-template-columns: 1fr;
                gap: 0;
            }

            .form-section-title {
                font-size: 1.1rem;
            }

            .btn-submit {
                padding: 14px;
                font-size: 1rem;
            }
        }

        @media (max-width: 480px) {
            .page-header h1 {
                font-size: 1.3rem;
                flex-direction: column;
                align-items: flex-start;
                gap: 10px;
            }

            .form-control-custom,
            .form-select-custom {
                padding: 12px;
                font-size: 0.95rem;
            }

            .info-badge {
                display: block;
                margin-left: 0;
                margin-top: 5px;
                width: fit-content;
            }
        }
      
.poc-card{
    background:#f8f9fa;
    border-radius:12px;
    padding:14px 16px;
    height:100%;
}

.poc-card span{
    font-size:12px;
    color:#6c757d;
    display:block;
    margin-bottom:4px;
}

.poc-card strong{
    font-size:14px;
    font-weight:600;
    color:#212529;
}




.form-control-custom,
.form-select-custom{
    width:100%;
    padding:10px 12px;
    border-radius:10px;
    border:1px solid #dee2e6;
    font-size:14px;
}

.form-control-custom:focus,
.form-select-custom:focus{
    border-color:#667eea;
    outline:none;
}

    </style>
</head>
<body>

<div class="page-container">
    <div class="page-header d-flex justify-content-between align-items-center">
    <div>
        <h1>
            <i class="fas fa-user-tie"></i>
            Add Brand Point of Contact
        </h1>
        <p>Add a new point of contact for brand communication and coordination</p>
    </div>

    <button class="btn btn-primary"
            data-bs-toggle="modal"
            data-bs-target="#pocListModal"
            onclick="loadBrandPocs()">
        <i class="fas fa-users"></i> All Brand POCs
    </button>
</div>


    <div class="form-container">
        @if(session('success'))
        <div class="alert-success-custom">
            <i class="fas fa-check-circle"></i>
            <span>{{session('success')}}</span>
        </div>
        @endif

        <form method="POST" action="/brand-poc">
@csrf

<!-- BRAND + CONTACT DETAILS -->
<div class="form-section">
    <div class="form-section-title">
        <i class="fas fa-user-tie"></i> Brand & Contact Details
    </div>

    <div class="row g-3">

        <!-- Brand -->
        <div class="col-md-3">
            <label>Select Brand <span class="required">*</span></label>
            <select name="brand_id"
        id="brand_id"
        class="form-select-custom"
        required>

                <option value="">Choose brand</option>
                @foreach($brands as $brand)
                    <option value="{{ $brand->id }}">{{ $brand->name }}</option>
                @endforeach
            </select>
        </div>

        <!-- Name -->
        <div class="col-md-3">
            <label>Full Name <span class="required">*</span></label>
            <input type="text" name="name"
                   class="form-control-custom"
                   placeholder="Full name" required>
        </div>

        <!-- Designation -->
        <div class="col-md-3">
            <label>Designation <span class="required">*</span></label>
            <input type="text" name="designation"
                   class="form-control-custom"
                   placeholder="Designation" required>
        </div>

        <!-- Zone -->
        <div class="col-md-3">
            <label>Zone <span class="required">*</span></label>
            <select name="zone" class="form-select-custom" required>
                <option value="">Select zone</option>
                <option>North</option>
                <option>South</option>
                <option>East</option>
                <option>West</option>
                <option>PAN India</option>
            </select>
        </div>

       <!-- Phone -->
<div class="col-md-3">
    <label>Phone <span class="required">*</span></label>
    <input type="tel"
           name="phone"
           class="form-control-custom"
           placeholder="91 XXXX XXXX"
           maxlength="10"
           pattern="[0-9]{10}"
           oninput="this.value = this.value.replace(/[^0-9]/g, '').slice(0,10)"
           required>
</div>


        <!-- Email -->
        <div class="col-md-3">
            <label>Email <span class="required">*</span></label>
            <input type="email" name="email"
                   class="form-control-custom"
                   placeholder="name@company.com" required>
        </div>

    </div>
</div>

<!-- SUBMIT -->
<div class="text-center mt-4">
   <button type="submit"
        id="submitBtn"
        class="btn-submit px-5">
    <i class="fas fa-user-plus"></i> Save Point of Contact
</button>

</div>

</form>

    </div>
</div>

<!-- ALL BRAND POC MODAL -->
<div class="modal fade" id="pocListModal" tabindex="-1">
    <div class="modal-dialog modal-xl modal-dialog-centered modal-dialog-scrollable">
        <div class="modal-content">

            <div class="modal-header">
                <h5><i class="fas fa-users"></i> Brand Point of Contacts</h5>
                <button class="btn-close" data-bs-dismiss="modal"></button>
            </div>

            <div class="modal-body">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>SR.No.</th>
                            <th> Select Brand</th>
                            <th>Name</th>
                            <th>Designation</th>
                            <th>Phone</th>
                            <th>Email</th>
                            <th>Zone</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody id="pocTable">
                        <tr>
                            <td colspan="8" class="text-center">Loading...</td>
                        </tr>
                    </tbody>
                </table>
                <div id="pocPagination" class="mt-3 d-flex justify-content-end"></div>

            </div>

        </div>
    </div>
</div>



<!-- EDIT BRAND POC MODAL -->
<div class="modal fade" id="editPocModal" tabindex="-1">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content">

            <div class="modal-header">
                <h5><i class="fas fa-edit"></i> Edit Brand POC</h5>
                <button class="btn-close" data-bs-dismiss="modal"></button>
            </div>

            <form id="editPocForm">
                @csrf
                @method('PUT')
<div class="modal-body">

    <input type="hidden" id="edit_id">

    <div class="row g-3">

        <!-- Brand -->
        <div class="col-md-4">
            <label>Select Brand <span class="required">*</span></label>
        <select name="brand_id"
        id="edit_brand_id"
        class="form-select-custom"
        required>

                <option value="">Choose brand</option>
                @foreach($brands as $brand)
                    <option value="{{ $brand->id }}">{{ $brand->name }}</option>
                @endforeach
            </select>
        </div>

        <!-- Name -->
        <div class="col-md-4">
            <label>Full Name</label>
            <input type="text" id="edit_name" name="name" class="form-control-custom">
        </div>

        <!-- Designation -->
        <div class="col-md-4">
            <label>Designation</label>
            <input type="text" id="edit_designation" name="designation" class="form-control-custom">
        </div>

        <!-- Phone -->
       <div class="col-md-4">
    <label>Phone</label>
    <input type="tel"
           id="edit_phone"
           name="phone"
           class="form-control-custom"
           placeholder="10 digit mobile number"
           maxlength="10"
           pattern="[0-9]{10}"
           oninput="this.value = this.value.replace(/[^0-9]/g, '').slice(0,10)">
</div>


        <!-- Email -->
        <div class="col-md-4">
            <label>Email</label>
            <input type="email" id="edit_email"  name="email" class="form-control-custom">
        </div>

        <!-- Zone -->
        <div class="col-md-4">
            <label>Zone</label>
            <select id="edit_zone" name="zone" class="form-select-custom">
                <option>North</option>
                <option>South</option>
                <option>East</option>
                <option>West</option>
                <option>PAN India</option>
            </select>
        </div>

    </div>
</div>


                <div class="modal-footer">
                    <button type="button" class="btn btn-success" onclick="updatePoc()">
                        <i class="fas fa-save"></i> Update
                    </button>
                </div>
            </form>

        </div>
    </div>
</div>




<!-- VIEW BRAND POC MODAL -->
<div class="modal fade" id="viewPocModal" tabindex="-1">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content">

            <div class="modal-header">
                <h5><i class="fas fa-eye"></i> View Brand POC</h5>
                <button class="btn-close" data-bs-dismiss="modal"></button>
            </div>

            <div class="modal-body" id="viewPocBody">
                <!-- Data dynamically aayega -->
            </div>

        </div>
    </div>
</div>

<script>


function editPoc(id){
    $.get(`/brand-poc/${id}`, function(poc){

        $('#edit_id').val(poc.id);
        $('#edit_brand_id').val(poc.brand_id);   // ✅ IMPORTANT
        $('#edit_name').val(poc.name);
        $('#edit_designation').val(poc.designation);
        $('#edit_phone').val(poc.phone);
        $('#edit_email').val(poc.email);
        $('#edit_zone').val(poc.zone);

        $('#editPocModal').modal('show');
    });
}

function updatePoc(){
    let id = $('#edit_id').val();

    $.ajax({
        url: `/brand-poc/${id}`,
        type: 'POST',
        data: {
            _method: 'PUT',
            _token: '{{ csrf_token() }}',

            brand_id: $('#edit_brand_id').val(), // ✅ REQUIRED
            name: $('#edit_name').val(),
            designation: $('#edit_designation').val(),
            phone: $('#edit_phone').val(),
            email: $('#edit_email').val(),
            zone: $('#edit_zone').val(),
        },
        success: function(){
            alert('POC Updated');
            $('#editPocModal').modal('hide');
            loadBrandPocs();
        }
    });
}


function deletePoc(id){
    if(!confirm('Delete this POC?')) return;

    $.ajax({
        url: `/brand-poc/${id}`,
        type: 'POST',
        data: {
            _method: 'DELETE',
            _token: '{{ csrf_token() }}'
        },
        success: function(){
            loadBrandPocs();
        }
    });
}
</script>

<script>
   
function loadBrandPocs(page = 1)
{
    $('#pocTable').html('<tr><td colspan="8">Loading...</td></tr>');
    $('#pocPagination').html('');

    $.ajax({
        url: `/brand-poc/list?page=${page}`,
        type: 'GET',
        success: function(res){

            console.log(res); // 🔥 VERY IMPORTANT (check browser console)

            if(!res.data || res.data.length === 0){
                $('#pocTable').html(
                    '<tr><td colspan="8" class="text-center">No POCs Found</td></tr>'
                );
                return;
            }

            let rows = '';
            let start = res.total - ((res.current_page - 1) * res.per_page);

            res.data.forEach((poc, index) => {
                rows += `
                <tr>
                    <td>${start - index}</td>
                    <td>${poc.brand ? poc.brand.name : '-'}</td>
                    <td>${poc.name}</td>
                    <td>${poc.designation}</td>
                    <td>${poc.phone}</td>
                    <td>${poc.email}</td>
                    <td>${poc.zone}</td>
                    <td>
                        <button class="btn btn-info btn-sm" onclick="viewPoc(${poc.id})">View</button>
                        <button class="btn btn-warning btn-sm" onclick="editPoc(${poc.id})">Edit</button>
                        <button class="btn btn-danger btn-sm" onclick="deletePoc(${poc.id})">Delete</button>
                    </td>
                </tr>`;
            });

            $('#pocTable').html(rows);

         // ✅ PREV + NEXT pagination
         if (res.total <= res.per_page) {
    $('#pocPagination').html('');
    return;
}
let pagination = '<div class="btn-group">';

// PREVIOUS
pagination += `
<button class="btn btn-sm btn-outline-primary"
    ${res.current_page === 1 ? 'disabled' : ''}
    onclick="loadBrandPocs(${res.current_page - 1})">
    &laquo; Prev
</button>
`;

// PAGE NUMBERS (max 5)
let startPage = Math.max(1, res.current_page - 2);
let endPage   = Math.min(res.last_page, res.current_page + 2);

for(let i = startPage; i <= endPage; i++){
    pagination += `
    <button class="btn btn-sm ${res.current_page === i ? 'btn-primary' : 'btn-outline-primary'}"
        onclick="loadBrandPocs(${i})">
        ${i}
    </button>
    `;
}

// NEXT
pagination += `
<button class="btn btn-sm btn-outline-primary"
    ${res.current_page === res.last_page ? 'disabled' : ''}
    onclick="loadBrandPocs(${res.current_page + 1})">
    Next &raquo;
</button>
`;

pagination += '</div>';

$('#pocPagination').html(pagination);

        },
        error: function(err){
            console.error(err);
            alert('Pagination API error – console check karo');
        }
    });
}
</script>





<script>
function viewPoc(id){
    $.get(`/brand-poc/${id}`, function(poc){

        $('#viewPocBody').html(`
            <div class="row g-3">

                <div class="col-md-4">
                    <div class="poc-card">
                        <span>Brand</span>
                        <strong>${poc.brand ? poc.brand.name : '-'}</strong>
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="poc-card">
                        <span>Name</span>
                        <strong>${poc.name}</strong>
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="poc-card">
                        <span>Designation</span>
                        <strong>${poc.designation}</strong>
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="poc-card">
                        <span>Phone</span>
                        <strong>${poc.phone}</strong>
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="poc-card">
                        <span>Email</span>
                        <strong>${poc.email}</strong>
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="poc-card">
                        <span>Zone</span>
                        <strong>${poc.zone}</strong>
                    </div>
                </div>

            </div>
        `);

        $('#viewPocModal').modal('show');
    });
}
</script>
<script>
function updatePoc(){
    let id = $('#edit_id').val();

    $.ajax({
        url: `/brand-poc/${id}`,
        type: 'POST',
        data: {
            _method: 'PUT',
            _token: '{{ csrf_token() }}',

            brand_id: $('#edit_brand_id').val(),
            name: $('#edit_name').val(),
            designation: $('#edit_designation').val(),
            phone: $('#edit_phone').val(),
            email: $('#edit_email').val(),
            zone: $('#edit_zone').val(),
        },
        success: function(){
            alert('POC Updated');
            $('#editPocModal').modal('hide');
            loadBrandPocs();
        },
        error: function(xhr){
            if(xhr.status === 422){
                let errors = xhr.responseJSON.errors;
                let msg = '';

                Object.keys(errors).forEach(function(key){
                    msg += errors[key][0] + '\n';
                });

                alert(msg); // 🔥 exact field ka error
            }
        }
    });
}
</script>
<script>
document.addEventListener('DOMContentLoaded', function () {

    const form = document.querySelector('form[action="/brand-poc"]');
    const submitBtn = document.getElementById('submitBtn');

    if (!form || !submitBtn) return;

    let submitted = false; // 🔒 LOCK

    form.addEventListener('submit', function (e) {

        if (submitted) {
            e.preventDefault(); // ❌ second submit block
            return false;
        }

        submitted = true; // ✅ first submit allowed

        submitBtn.disabled = true;
        submitBtn.innerHTML = `
            <i class="fas fa-spinner fa-spin"></i> Saving...
        `;
    });
});
</script>


@endsection