@extends('layouts.app')



@section('title','Dashboard')

@section('content')




<!-- ================= CDN ================= -->
<link rel="stylesheet"
    href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">

<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>

<!-- Select2 -->
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<!-- Date Range Picker -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
<script src="https://cdn.jsdelivr.net/npm/moment@2.29.4/moment.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>



<div class="container " style="background-color:#ffffff; border-radius:20px;";>
    <div class="dashboard-header">
        <h1 class="dashboard-title pt-3">
            Welcome, {{ auth()->user()->name }}
        </h1>
        <p class="dashboard-subtitle">
            Manage your business operations efficiently
        </p>
    </div>

    <div class="row g-4 mb-4">

        <div class="col-6 col-md-2">
            <div class="card text-center ">
                <h6 class="mt-2">Today</h6>
                <h4 class="fw-bold text-primary">{{ $todayCount }}</h4>
            </div>
        </div>

        <div class="col-6 col-md-2">
            <div class="card text-center ">
                <h6 class="mt-2">Yesterday</h6>
                <h4 class="fw-bold text-danger">{{ $yesterdayCount }}</h4>
            </div>
        </div>

        <div class="col-6 col-md-2">
            <div class="card text-center">
                <h6 class="mt-2">Week</h6>
                <h4 class="fw-bold text-warning">{{ $weekCount }}</h4>
            </div>
        </div>

        <div class="col-6 col-md-2">
            <div class="card text-center ">
                <h6 class="mt-2">Month</h6>
                <h4 class="fw-bold text-success">{{ $monthCount }}</h4>
            </div>
        </div>

        <div class="col-6 col-md-2">
            <div class="card text-center ">
                <h6 class="mt-2">Year</h6>
                <h4 class="fw-bold text-info">{{ $yearCount }}</h4>
            </div>
        </div>

        <div class="col-6 col-md-2">
            <div class="card text-center shadow-sm border-primary">
                <h6 class="mt-2">Total</h6>
                <h4 class="fw-bold text-dark">{{ $totalCount }}</h4>
            </div>
        </div>

    </div>

    <div class="row">

        <!-- ================= LEFT FILTER ================= -->
        <div class="col-md-3">
            <form method="GET" action="{{ route('opportunities.index') }}">

                <div class="card filter-card mb-4">
                    <div class="card-header">
                        <i class="fas fa-filter me-2"></i>Filters
                    </div>

                    <div class="card-body">

                        <!-- CITY -->
                        <div class="mb-3">
                            <label class="form-label">
                                <i class="fas fa-city me-2 text-primary"></i> City
                            </label>

                            <select name="cities[]" id="cities"
                                class="form-select select2"
                                multiple
                                data-placeholder="Search city">
                                @foreach(\App\Models\City::all() as $city)
                                <option value="{{ $city->id }}"
                                    {{ in_array($city->id, request('cities', [])) ? 'selected' : '' }}>
                                    {{ $city->name }}
                                </option>
                                @endforeach
                            </select>
                        </div>

                        <!-- MARKET -->
                        <div class="mb-3">
                            <label class="form-label">
                                <i class="fas fa-store me-2 text-primary"></i> Market
                            </label>

                            <select name="markets[]" id="markets"
                                class="form-select select2"
                                multiple
                                data-placeholder="Search market">
                                @foreach(\App\Models\Market::all() as $market)
                                <option value="{{ $market->id }}"
                                    {{ in_array($market->id, request('markets', [])) ? 'selected' : '' }}>
                                    {{ $market->name }}
                                </option>
                                @endforeach
                            </select>
                        </div>

                        <!-- DATE -->
                        <div class="mb-4">
                            <label class="form-label">
                                <i class="fas fa-calendar-alt me-2 text-primary"></i>
                                Date Range
                            </label>

                            <div class="input-group">
                                <span class="input-group-text">
                                    <i class="fas fa-calendar-alt"></i>
                                </span>
                                <input type="text"
                                    id="dateRange"
                                    class="form-control"
                                    placeholder="Select date range"
                                    readonly
                                    style="background:#fff; cursor:pointer;">
                            </div>

                            <input type="hidden" name="date_filter" id="date_filter" value="{{ request('date_filter') }}">
                            <input type="hidden" name="date_from" id="date_from" value="{{ request('date_from') }}">
                            <input type="hidden" name="date_to" id="date_to" value="{{ request('date_to') }}">
                        </div>

                        <button type="submit" class="btn btn-primary w-100 mb-2">

                            <i class="fas fa-search me-2"></i>Apply Filters
                        </button>

                        <a href="{{ route('opportunities.index') }}"
                            class="btn btn-outline-secondary w-100">
                            <i class="fas fa-redo me-2"></i>Reset Filters
                        </a>



                        <button type="submit" name="export" value="excel"
                            class="btn btn-warning
         w-100 mt-2">
                            <i class="fas fa-file-excel me-2"></i>Download Excel
                        </button>


                    </div>
                </div>
            </form>
        </div>

        <!-- ================= RIGHT TABLE ================= -->
        <div class="col-md-9">

            <div class="card table-card">
                <div class="card-body">

                    <div class="table-responsive">

                        <h3 class="text-center pt-3">Matched Opportunities</h3>



                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th width="80">SR.No.</th>
                                    <th>Brand</th>
                                    <th>Market</th>
                                    <th width="120">Actions</th>
                                </tr>
                            </thead>

                            <tbody>
                                @php
                                $start = $opportunities->total()
                                - (($opportunities->currentPage() - 1)
                                * $opportunities->perPage());
                                @endphp

                                @forelse($opportunities as $i => $op)
                                <tr>
                                    <td><strong>{{ $start - $i }}</strong></td>
                                    <td>{{ $op->brand->name ?? '-' }}</td>
                                    <td>{{ $op->market->name ?? '-' }}</td>
                                    <td>
                                      <button class="btn btn-primary btn-sm view-btn"
        data-id="{{ $op->id }}">
    <i class="fas fa-eye me-1"></i>View
</button>

                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="4" class="empty-state">
                                        <i class="fas fa-inbox"></i>
                                        <p class="mb-0"><strong>No opportunities found</strong></p>
                                        <small>Try adjusting your filters to see more results</small>
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    @if($opportunities->hasPages())
                    <div class="d-flex justify-content-center">
                        {{ $opportunities->appends(request()->query())->links() }}
                    </div>
                    @endif

                </div>
            </div>

        </div>
    </div>
</div>

@include('opportunities.modal')

<!-- ================= JS ================= -->
<script>
    $(document).ready(function() {

        /* ===== SELECT2 ===== */
        $('.select2').select2({
            width: '100%',
            closeOnSelect: false,
            placeholder: function() {
                return $(this).data('placeholder');
            }
        });

        /* ===== DATE RANGE PICKER ===== */
        $('#dateRange').daterangepicker({
            autoUpdateInput: false,
            opens: 'left',
            ranges: {
                'Today': [moment(), moment()],
                'Yesterday': [
                    moment().subtract(1, 'days'),
                    moment().subtract(1, 'days')
                ],
                'Last 7 Days': [
                    moment().subtract(6, 'days'),
                    moment()
                ],
                'Last 30 Days': [
                    moment().subtract(29, 'days'),
                    moment()
                ],
                'This Month': [
                    moment().startOf('month'),
                    moment().endOf('month')
                ],
                'Last Month': [
                    moment().subtract(1, 'month').startOf('month'),
                    moment().subtract(1, 'month').endOf('month')
                ]
            }
        }, function(start, end, label) {

            $('#date_from').val(start.format('YYYY-MM-DD'));
            $('#date_to').val(end.format('YYYY-MM-DD'));

            if (label === 'Today' || label === 'Yesterday') {
                $('#date_filter').val(label.toLowerCase());
                $('#dateRange').val(label);
            } else {
                $('#date_filter').val('');
                $('#dateRange').val(
                    start.format('MMMM D, YYYY') +
                    ' - ' +
                    end.format('MMMM D, YYYY')
                );
            }
        });

        /* ===== Restore date text after reload ===== */
        const from = $('#date_from').val();
        const to = $('#date_to').val();
        if (from && to) {
            $('#dateRange').val(
                moment(from).format('MMMM D, YYYY') +
                ' - ' +
                moment(to).format('MMMM D, YYYY')
            );
        }
    });
</script>
<script>
    $(document).ready(function() {

        $('.select2').select2({
            width: '100%',
            closeOnSelect: false,
            placeholder: function() {
                return $(this).data('placeholder');
            }
        });

        // 🔥 FORCE select2 values into form on submit
        $('form').on('submit', function() {
            $('#cities').val($('#cities').val());
            $('#markets').val($('#markets').val());
        });
    });
</script>
<script>
document.addEventListener('click', function (e) {
    if (e.target.closest('.view-btn')) {
        const id = e.target.closest('.view-btn').dataset.id;
        viewOpportunity(id);
    }
});
</script>


@endsection