



<?php $__env->startSection('title','Inventory'); ?>

<?php $__env->startSection('content'); ?>

<style>
/* =========================================
    FINAL FIX: ADDITIONAL DETAILS RESPONSIVE
========================================= */
/* DESKTOP */
.form-row-6 {
    display: grid;
    grid-template-columns: repeat(5, 1fr);
    gap: 20px;
}
/* TABLET */
@media (max-width: 992px) {
    .form-row-6 {
        grid-template-columns: repeat(2, 1fr);
    }
}
/* MOBILE */
@media (max-width: 768px) {
    .form-row-6 {
        grid-template-columns: 1fr !important;
    }
    .form-group {
        width: 100%;
    }
    .form-section-title {
        font-size: 1.05rem;
    }
    .form-group label {
        font-size: 13px;
    }
    .form-group label i {
        font-size: 13px;
        margin-right: 6px;
    }
}
/* SMALL MOBILE */
@media (max-width: 480px) {
    .form-control-custom,
    .form-select-custom {
        padding: 12px;
        font-size: 0.95rem;
    }
}
</style>

<div class="page-container">
    <div class="page-header inventory-header bg-primary">
         <div>
           <h1 class="text-white "style="padding-left:15px">
            <i class="fas fa-warehouse text-white"></i>
            Add New Inventory
              </h1>
              <p class="text-white "style="padding-left:15px">Add a new property to your retail inventory database</p>
               </div>

                <!-- RIGHT SIDE BUTTON -->
                <button class="btn btn-primary me-5" data-bs-toggle="modal" data-bs-target="#inventoryPreviewModal">
                <i class="fas fa-list"></i> All Inventories
                  </button>
                    </div>


                    <div class="form-container">
                        <?php if($errors->any()): ?>
<div class="alert alert-danger">
    <ul class="mb-0">
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <li><?php echo e($error); ?></li>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </ul>
</div>
<?php endif; ?>   
                      <?php if(session('success')): ?>
                     <div class="alert-success-custom">
                      <i class="fas fa-check-circle"></i>
                       <span><?php echo e(session('success')); ?></span>
                       </div>
                        <?php endif; ?>

                       <form method="POST" action="/inventory" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>

       


                       <!-- LOCATION -->
                         <div class="form-section">
                           <div class="form-section-title">
                          <i class="fas fa-location-arrow"></i>
                            Location Information
                             </div>

                             <div class="form-row-5">
                             <div class="form-group">
                            <label>
                          <i class="fas fa-user"></i>
IX RM Name
<span class="required">*</span>
</label>
<select name="rm_name" id="rm_name" class="form-select-custom"required>
<option value="">Select IX RM Name</option>
<option value="Manav Kapila">Manav Kapil</option>
<option value="Kunal Pandey">Kunal Pandey</option>
<option value="Rajan Malik">Rajan Malik</option>
<option value="Krishna Nagar">Krishna Nagar</option>
<option value="Mohammad Sarim">Mohammad Sarim</option>
<option value="Maneeshima Ray">Maneeshima Ray</option>
</select>
                       </div>








                                    <div class="form-group">
                                      <label for="type">
                                  <i class="fas fa-home"></i>
                                    Property Type
                                    <span class="required">*</span>
                                          </label>
                                        <select name="type" id="type" class="form-select-custom" required>
                                        <option value="">Select Type</option>
                                        <option value="High Street">High Street</option>
                                        <option value="Mall">Mall</option>
                                   </select>
                                 </div>

                              <div class="form-group">
                              <label for="state">
                               <i class="fas fa-map"></i>
                               State
                             <span class="required">*</span>
                            </label>
                            <select id="state" name="state_id" class="form-select-custom select2 form-control-custom" required>

                            <option value="">Select State</option>
                           </select>
                           </div>
                            <div class="form-group">
                            <label for="city">
                            <i class="fas fa-city"></i>
                            City
                            <span class="required">*</span>
                              </label>
                           <select id="city" name="city_id" class="form-select-custom select2 form-control-custom" required>

                            <option value="">Select City</option>
                           </select>
                           </div>



                            <div class="form-group">
                               <label for="market">
                               <i class="fas fa-shopping-bag"></i>
                               Market
                              <span class="required">*</span>
                               </label>
                               <select id="market" name="market_id" class="form-select-custom select2 form-control-custom" required>

                               <option value="">Select Market</option>
                               </select>
                                   </div>
                                     <div class="form-group">
                                  <label for="unit_address">
                              <i class="fas fa-map-marker-alt"></i>
                                 Unit/Address
                             <span class="required">*</span>
                              </label> <input type="text" name="unit_address"  id="unit_address" class="form-control-custom" placeholder="Enter your unit/address"required>
                              </div>  
                           </div>
                          </div>

            <!-- POC -->
            <div class="form-section">
                <div class="form-section-title">
                    <i class="fas fa-user-tie"></i>
                    Point of Contact
                </div>

                <div class="form-row-4">
                    <div class="form-group">
                        <label for="poc_name">
                            <i class="fas fa-id-card"></i>
                            POC Name
                            <span class="required">*</span>
                        </label>
                        <input type="text" 
                               name="poc_name" 
                               id="poc_name" 
                               class="form-control-custom" 
                               placeholder="Enter POC name"
                               required>
                              </div>

                            <div class="form-group">
                            <label for="designation">
                            <i class="fas fa-briefcase"></i>
                            Designation
                            <span class="required">*</span>
                             </label>
                              <input type="text" 
                               name="designation" 
                               id="designation" 
                               class="form-control-custom" 
                               placeholder="e.g., Property Manager"
                               required>
                              </div>

                               <div class="form-group">
                              <label for="mobile">
                              <i class="fas fa-phone"></i>
                              Mobile Number
                            <span class="required">*</span>
                            </label>

                            <input type="tel"
                             name="mobile"
                             id="mobile"
                             class="form-control-custom"
                             placeholder="+91 XXXXX XXXXX"
                             maxlength="10"
                             pattern="[0-9]{10}"
                             oninput="this.value = this.value.replace(/[^0-9]/g, '').slice(0,10)"
                             required>
                             </div>

                            <div class="form-group">
                            <label for="email">
                            <i class="fas fa-envelope"></i>
                             Email Address
                            <span class="required">*</span>
                             </label>
                               <input type="email" 
                               name="email" 
                               id="email" 
                               class="form-control-custom" 
                               placeholder="poc@example.com"
                               required>
                             </div>
                         </div>

                      <!-- RENT DETAILS -->
                       <div class="form-section">
                       <div class="form-section-title">
                        <i class="fas fa-rupee-sign"></i>
                        Rental Information
                      </div>
                <div class="form-row-3">
                    <div class="form-group">
                        <label for="area">
                            <i class="fas fa-ruler-combined"></i>
                            Area (Sq Ft)
                            <span class="required">*</span>
                             </label>
                               <input type="number" 
                               name="area" 
                               id="area" 
                               class="form-control-custom" 
                               placeholder="Enter area"
                               required>
                          </div>

                    <div class="form-group">
                        <label for="rate">
                            <i class="fas fa-calculator"></i>
                            Rate per Sq Ft
                            <span class="required">*</span>
                              </label>
                              <input type="number" 
                               name="rate" 
                               id="rate" 
                               class="form-control-custom" 
                               placeholder="Enter rate"
                               required>
                              </div>

                    <div class="form-group">
                        <label for="rent">
                            <i class="fas fa-money-bill-wave"></i>
                            Monthly Rent
                            <span class="calculated-badge">Auto-calculated</span>
                             </label>
                             <input type="text" 
                               name="monthly_rent" 
                               id="rent" 
                               class="form-control-custom" 
                               placeholder="Auto-calculated"
                               readonly>
                    </div>
                </div>
            </div>

            <!-- ADDITIONAL DETAILS -->
            <div class="form-section ">
                <div class="form-section-title">
                    <i class="fas fa-info-circle"></i>
                    Additional Details
                </div>

                <div class="form-row-6">
                 

                <div class="form-group">
    <label for="floor">
        <i class="fas fa-layer-group"></i>
        Floor
        <span class="required">*</span>
    </label>
    <select name="floor"
            id="floor"
            class="form-select-custom"
            required>
        <option value="">Select Floor</option>
        <option value="LGF">LGF</option>
        <option value="GF">GF </option>
        <option value="FF">FF</option>
        <option value="SF">SF</option>
        <option value="3rd">3rd floor</option>
        <option value="4th">4th floor</option>
    </select>
</div>


                    <div class="form-group">
                        <label for="frontage">
                            <i class="fas fa-arrows-alt-h"></i>
                            Frontage (Ft)
                            <span class="required">*</span>
                        </label>
                        <input type="text" 
                               name="frontage" 
                               id="frontage" 
                               class="form-control-custom" 
                               placeholder="Enter frontage"required>
                    </div>
                    <div class="form-group">
                        <label for="availability">
                            <i class="fas fa-door-open"></i>
                            Availability Status
                            <span class="required">*</span>
                        </label>
                        <select name="availability" id="availability" class="form-select-custom" required>
                            <option value="">Select Status</option>
                            <option value="Yes">Available</option>
                            <option value="No">Not Available</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="current_brand">
                            <i class="fas fa-tag"></i>
                            Current Brand/Tenant
                            <span class="required">*</span>
                        </label>
                        <input type="text" 
                               name="current_brand" 
                               id="current_brand" 
                               class="form-control-custom" 
                               placeholder="Enter current brand"required>
                    </div>

                <div class="form-group">
                    <label for="vacant_date">
                        <i class="fas fa-calendar-alt"></i>
                        Expected Vacant Date
                        <span class="required">*</span>
                    </label>
                    <input type="date" 
                           name="vacant_date" 
                           id="vacant_date" 
                           class="form-control-custom"required>
                </div>
             </div>
            </div>

            <!-- IMAGES -->
            <div class="form-section">
                <div class="form-section-title">
                    <i class="fas fa-images"></i>
                    Property Images
                    
                </div>
                <div class="form-row-4">
                    <div class="form-group">
                        <label for="front_view">
                            <i class="fas fa-image"></i>
                            Front View
                            <span class="required">*</span>
                        </label>
                        <div class="file-input-wrapper">
                            <input type="file" 
                                   name="front_view" 
                                   id="front_view" 
                                   accept="image/*"
                                   required
                                   onchange="updateFileName(this, 'frontFileName')">
                            <label for="front_view" class="file-input-label">
                                <i class="fas fa-cloud-upload-alt"></i>
                                <span class="required">Upload Front View</span>
                            </label>
                        </div>
                        <div class="file-name" id="frontFileName">
                            <i class="fas fa-file-image"></i>
                            <span></span>
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="left_view">
                            <i class="fas fa-image"></i>
                            Left View
                            <span class="required">*</span>
                        </label>
                        <div class="file-input-wrapper">
                            <input type="file" 
                                   name="left_view" 
                                   id="left_view" 
                                   accept="image/*"
                                   required
                                   onchange="updateFileName(this, 'leftFileName')" required>
                            <label for="left_view" class="file-input-label">
                                <i class="fas fa-cloud-upload-alt"></i>
                                <span class="required">Upload Left View</span>
                            </label>
                        </div>
                        <div class="file-name" id="leftFileName">
                            <i class="fas fa-file-image"></i>
                            <span></span>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="right_view">
                            <i class="fas fa-image"></i>
                            Right View
                            <span class="required">*</span>
                        </label>
                        <div class="file-input-wrapper">
                            <input type="file" 
                                   name="right_view" 
                                   id="right_view" 
                                   accept="image/*"
                                   required
                                   onchange="updateFileName(this, 'rightFileName')">
                            <label for="right_view" class="file-input-label">
                                <i class="fas fa-cloud-upload-alt"></i>
                                <span class="required">Upload Right View</span>
                            </label>
                        </div>
                        <div class="file-name" id="rightFileName">
                            <i class="fas fa-file-image"></i>
                            <span></span>
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="interior_view">
                            <i class="fas fa-image"></i>
                            Interior View
                            <span class="required">*</span>
                        </label>
                        <div class="file-input-wrapper">
                            <input type="file" 
                                   name="interior_view" 
                                   id="interior_view" 
                                   accept="image/*"
                                   required
                                   onchange="updateFileName(this, 'interiorFileName')">
                            <label for="interior_view" class="file-input-label">
                                <i class="fas fa-cloud-upload-alt"></i>
                                <span class="required">Upload Interior View</span>
                                 
                            </label>
                        </div>
                        <div class="file-name" id="interiorFileName">
                            <i class="fas fa-file-image"></i>
                            <span></span>
                        </div>
                    </div>
                </div>
            </div>

            <button type="submit" class="btn-submit">
                <i class="fas fa-save"></i>
                Save Inventory
            </button>
        </form>
    </div>
</div>



<!-- INVENTORY LIST MODAL -->
<div class="modal fade" id="inventoryPreviewModal" tabindex="-1">
    <div class="modal-dialog modal-xl modal-dialog-centered modal-dialog-scrollable">
        <div class="modal-content">

            <div class="modal-header">
                <h5><i class="fas fa-boxes"></i> All Inventories</h5>
                <button class="btn-close" data-bs-dismiss="modal"></button>
            </div>

            <div class="modal-body">
                <div class="table-responsive">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>SR.No.</th>
                            <th>Type</th>
                            <th>State</th>
                            <th>City</th>
                            <th>Market</th>
                            <th>Area</th>
                            <th>Rent</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody id="inventoryTable">
                        <tr>
                            <td colspan="8" class="text-center">Loading...</td>
                        </tr>
                    </tbody>
                </table>
</div>
           <div id="inventoryPagination" class="mt-3 d-flex justify-content-center"></div>


            
            </div>

        </div>
    </div>
</div>

<!-- VIEW MODAL -->
<div class="modal fade" id="viewInventoryModal">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5><i class="fas fa-eye"></i> Inventory Details</h5>
                <button class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="viewInventoryBody">
                Loading...
            </div>
        </div>
    </div>
</div>






<!-- EDIT INVENTORY MODAL  -->
<div class="modal fade" id="editInventoryModal" tabindex="-1">
    <div class="modal-dialog modal-xl modal-dialog-centered modal-dialog-scrollable">   
        <div class="modal-content">
             
            <div class="modal-header">
                <h5>
                    <i class="fas fa-edit"></i> Edit Inventory
                </h5>
                <button class="btn-close" data-bs-dismiss="modal"></button>
            </div>

            <div class="modal-body">

                <form id="editInventoryForm" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>

                    <!-- 🔁 SAME CREATE FORM COPY HERE -->


            <!-- LOCATION -->
            <div class="form-section">
                <div class="form-section-title">
                    <i class="fas fa-location-arrow"></i>
                    Location Information
                </div>

                <div class="form-row-5">
                    <div class="form-group">
    <label>
        <i class="fas fa-user"></i>
       IX RM Name
        <span class="required">*</span>
    </label>

    <select name="rm_name"
            id="edit_rm_name"
            class="form-select-custom"
            required>
       <option value="">Select IX RM Name</option>
<option value="Manav Kapila">Manav Kapila</option>
<option value="Kunal Pandey">Kunal Pandey</option>
<option value="Rajan Malik">Rajan Malik</option>
<option value="Krishna Nagar">Krishna Nagar</option>
<option value="Mohammad Sarim">Mohammad Sarim</option>
<option value="Maneeshima Ray">Maneeshima Ray</option>
    </select>
</div>

                    
                <div class="form-group">
                    <label for="type">
                        <i class="fas fa-home"></i>
                        Property Type
                        <span class="required">*</span>
                    </label>
                   <!-- PROPERTY TYPE -->
  
                   <select name="type" id="edit_type" class="form-select-custom" required>
                   <option value="">Select Type</option>
                   <option value="High Street">High Street</option>
                   <option value="Mall">Mall</option>
                   </select>
                   </div>

                       
                            <div class="form-group">
                          <label for="state">
                            <i class="fas fa-map"></i>
                            State
                            <span class="required">*</span>
                        </label>
                     
                <select id="edit_state" name="state_id" class="form-select-custom select2" required></select>

                    </div>

                    <div class="form-group">
                        <label for="city">
                            <i class="fas fa-city"></i>
                            City
                            <span class="required">*</span>
                        </label>
                        <!-- CITY -->
             <select id="edit_city" name="city_id" class="form-select-custom select2" required></select>

                    </div>

                    <div class="form-group">
                        <label for="market">
                            <i class="fas fa-shopping-bag"></i>
                            Market
                            <span class="required">*</span>
                        </label>
                        <!-- MARKET -->
       <select id="edit_market" name="market_id" class="form-select-custom select2" required></select>

                    </div>
                       <div class="form-group">
                          <label for="unit_address">
                           <i class="fas fa-map-marker-alt"></i>
                            Unit Address
                          <span class="required">*</span>
                           </label>
                   
                            <!-- UNIT ADDRESS -->
                            <input type="text"
                             name="unit_address"
                             id="edit_unit_address"
                             class="form-control-custom"
                             required>
                            </div>
                </div>
            </div>

            <!-- POC -->
            <div class="form-section">
                <div class="form-section-title">
                    <i class="fas fa-user-tie"></i>
                    Point of Contact
                </div>

                <div class="form-row-4">
                    <div class="form-group">
                        <label for="poc_name">
                            <i class="fas fa-id-card"></i>
                            POC Name
                            <span class="required">*</span>
                        </label>
                              <input type="text" 
                              name="poc_name"
                              id="edit_poc_name"
                              class="form-control-custom"
                              required>
                    </div>

                    <div class="form-group">
                        <label for="designation">
                            <i class="fas fa-briefcase"></i>
                            Designation
                            <span class="required">*</span>
                        </label>
                        <input type="text" 
                               name="designation" 
                               id="edit_designation" 
                               class="form-control-custom" 
                               placeholder="e.g., Property Manager"
                               required>
                    </div>
                    <div class="form-group">
                        <label for="mobile">
                            <i class="fas fa-phone"></i>
                            Mobile Number
                            <span class="required">*</span>
                        </label>
                        <input type="tel" 
                               name="mobile" 
                               id="edit_mobile" 
                               class="form-control-custom" 
                               placeholder="+91 XXXXX XXXXX"
                               required>
                    </div>

                    <div class="form-group">
                        <label for="email">
                            <i class="fas fa-envelope"></i>
                            Email Address
                            <span class="required">*</span>
                        </label>
                        <input type="email" 
                               name="email" 
                               id="edit_email" 
                               class="form-control-custom" 
                               placeholder="poc@example.com"
                               required>
                    </div>
            </div>

            <!-- RENT DETAILS -->
            <div class="form-section">
                <div class="form-section-title">
                    <i class="fas fa-rupee-sign"></i>
                    Rental Information
                </div>
                <div class="form-row-3">
                    <div class="form-group">
                        <label for="area">
                            <i class="fas fa-ruler-combined"></i>
                            Area (Sq Ft)
                            <span class="required">*</span>
                        </label>
                        
<input type="number" name="area" id="edit_area" class="form-control-custom">
                    </div>

                    <div class="form-group">
                        <label for="rate">
                            <i class="fas fa-calculator"></i>
                            Rate per Sq Ft
                            <span class="required">*</span>
                        </label>
                       
<input type="number" name="rate" id="edit_rate" class="form-control-custom">
                    </div>

                    <div class="form-group">
                        <label for="rent">
                            <i class="fas fa-money-bill-wave"></i>
                            Monthly Rent
                            <span class="calculated-badge">Auto-calculated</span>
                        </label>
                       <input type="text"
       name="monthly_rent"
       id="edit_rent"
       class="form-control-custom"
       readonly>

                    </div>
                </div>
            </div>

            <!-- ADDITIONAL DETAILS -->
            <div class="form-section">
                <div class="form-section-title">
                    <i class="fas fa-info-circle"></i>
                    Additional Details
                </div>

                <div class="form-row-6">
                   <div class="form-group">
    <label for="edit_floor">
        <i class="fas fa-layer-group"></i>
        Floor
        <span class="required">*</span>
    </label>

    <select name="floor"
            id="edit_floor"
            class="form-select-custom"
            required>
        <option value="">Select Floor</option>
        <option value="LGF">LGF</option>
        <option value="GF">GF</option>
        <option value="FF">FF</option>
        <option value="SF">SF</option>
        <option value="3rd">3rd</option>
        <option value="4th">4th</option>
    </select>
</div>

                    <div class="form-group">
                        <label for="frontage">
                            <i class="fas fa-arrows-alt-h"></i>
                            Frontage (Ft)
                             <span class="required">*</span>
                        </label>
                        <input type="text" 
                               name="frontage" 
                               id="edit_frontage" 
                               class="form-control-custom" 
                               placeholder="Enter frontage" required>
                    </div>
                    <div class="form-group">
                        <label for="availability">
                            <i class="fas fa-door-open"></i>
                            Availability Status
                            <span class="required">*</span>
                        </label>
                        <select name="availability" id="edit_availability" class="form-select-custom" required>
                            <option value="">Select Status</option>
                            <option value="Yes">Available</option>
                            <option value="No">Not Available</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="current_brand">
                            <i class="fas fa-tag"></i>
                            Current Brand/Tenant
                             <span class="required">*</span>
                        </label>
                        <input type="text" 
                               name="current_brand" 
                               id="edit_current_brand" 
                               class="form-control-custom" 
                               placeholder="Enter current brand" required>
                    </div>

                <div class="form-group">
                    <label for="vacant_date">
                        <i class="fas fa-calendar-alt"></i>
                        Expected Vacant Date
                         <span class="required">*</span>
                    </label>
                    <input type="date" 
                           name="vacant_date" 
                           id="edit_vacant_date" 
                           class="form-control-custom" required>
                </div>
             </div>
            </div>

            <!-- IMAGES -->
            <div class="form-section">
                <div class="form-section-title">
                    <i class="fas fa-images"></i>
                    Property Images
                </div>
                <div class="form-row-4">
                    <div class="form-group">
                        <label for="edit_front_view">
                            <i class="fas fa-image"></i>
                            Front View
                             <span class="required">*</span>
                        </label>
                         <!-- ✅ PREVIEW CONTAINER -->
    <div id="edit_front_preview" class="mb-2"></div>
                        <div class="file-input-wrapper">
                            <input type="file" 
                                   name="front_view" 
                                   id="edit_front_view" 
                                   accept="image/*"
                                   onchange="updateFileName(this, 'editfrontFileName')">
                            <label for="edit_front_view" class="file-input-label"> ✅

                                <i class="fas fa-cloud-upload-alt"></i>
                                <span>Upload Front View</span>
                            </label>
                        </div>
                        <div class="file-name" id="editfrontFileName">
                            <i class="fas fa-file-image"></i>
                            <span></span>
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="edit_left_view">
                            <i class="fas fa-image"></i>
                            Left View
                             <span class="required">*</span>
                        </label>
                        <div class="file-input-wrapper">
                            <div id="edit_left_preview" class="mb-2"></div>
                            <input type="file" 
                                   name="left_view" 
                                   id="edit_left_view" 
                                   accept="image/*"
                                   onchange="updateFileName(this, 'editleftFileName')">
                            <label for="edit_left_view" class="file-input-label">
                                <i class="fas fa-cloud-upload-alt"></i>
                                <span>Upload Left View</span>
                            </label>
                        </div>
                        <div class="file-name" id="editleftFileName">
                            <i class="fas fa-file-image"></i>
                            <span></span>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="edit_right_view">
                            <i class="fas fa-image"></i>
                            Right View
                             <span class="required">*</span>
                        </label>
                        <div class="file-input-wrapper">
                            <div id="edit_right_preview" class="mb-2"></div>
                            <input type="file" 
                                   name="right_view" 
                                   id="edit_right_view" 
                                   accept="image/*"
                                   onchange="updateFileName(this, 'editrightFileName')">
                            <label for="edit_right_view" class="file-input-label">
                                <i class="fas fa-cloud-upload-alt"></i>
                                <span>Upload Right View</span>
                            </label>
                        </div>
                        <div class="file-name" id="editrightFileName">
                            <i class="fas fa-file-image"></i>
                            <span></span>
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="edit_interior_view">
                            <i class="fas fa-image"></i>
                            Interior View
                             <span class="required">*</span>
                        </label>
                        <div class="file-input-wrapper">
                            <div id="edit_interior_preview" class="mb-2"></div>
                            <input type="file" 
                                   name="interior_view" 
                                   id="edit_interior_view" 
                                   accept="image/*"
                                   onchange="updateFileName(this, 'editinteriorFileName')">
                            <label for="edit_interior_view" class="file-input-label">
                                <i class="fas fa-cloud-upload-alt"></i>
                                <span>Upload Interior View</span>
                            </label>
                        </div>
                        <div class="file-name" id="editinteriorFileName">
                            <i class="fas fa-file-image"></i>
                            <span></span>
                        </div>
                    </div>
                </div>
            </div>

                    <button class="btn-submit">
                        <i class="fas fa-save"></i> Update Inventory
                    </button>

                </form>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

<script>


/* OPEN MODAL */

$(document).ready(function(){

    /* OPEN MODAL */
    $('#inventoryPreviewModal').on('shown.bs.modal', function () {
        loadInventoryTable(1);
    });

});


/* LOAD INVENTORY */
function loadInventoryTable(page = 1) {

    currentPage = page;

    $('#inventoryTable').html(`
        <tr>
            <td colspan="8" class="text-center">Loading...</td>
        </tr>
    `);

    $.get(`/inventory/list?page=${page}`, function (res) {

        let rows = '';

        if (res.data.length === 0) {
            rows = `
                <tr>
                    <td colspan="8" class="text-center">No Inventory Found</td>
                </tr>`;
        } else {

          // 🔥 total records ke basis pe start number
let start = res.total - ((res.current_page - 1) * res.per_page);

res.data.forEach((item, index) => {
    let sr = start - index;

                rows += `
                <tr>
                    <td>${sr}</td>
                    <td>${item.type ?? '-'}</td>
                    <td>${item.state?.name ?? '-'}</td>
                    <td>${item.city?.name ?? '-'}</td>
                    <td>${item.market?.name ?? '-'}</td>
                    <td>${item.area ?? '-'}</td>
                    <td>₹ ${item.monthly_rent ?? '-'}</td>
                    <td>
                        <button class="btn btn-info btn-sm"
                            onclick="viewInventory(${item.id})">View</button>

                        <button class="btn btn-warning btn-sm"
                            onclick="openEditInventory(${item.id})">Edit</button>

                        <button class="btn btn-danger btn-sm"
                            onclick="deleteInventory(${item.id})">Delete</button>
                    </td>
                </tr>`;
            });
        }

        $('#inventoryTable').html(rows);
        renderPagination(res);
    });
}

/* PAGINATION */

function renderInventoryPagination(res) {

    if (res.last_page <= 1) {
        $('#inventoryPagination').html('');
        return;
    }

    let html = '<div class="btn-group">';

    /* PREV */
    html += `
    <button class="btn btn-sm btn-outline-primary"
        ${res.current_page === 1 ? 'disabled' : ''}
        onclick="loadInventoryTable(${res.current_page - 1})">
        &laquo; Prev
    </button>
    `;

    /* PAGE NUMBERS (max 5) */
    let pageStart = Math.max(1, res.current_page - 2);
    let pageEnd   = Math.min(res.last_page, res.current_page + 2);

    for (let i = pageStart; i <= pageEnd; i++) {
        html += `
        <button class="btn btn-sm ${res.current_page === i ? 'btn-primary' : 'btn-outline-primary'}"
            onclick="loadInventoryTable(${i})">
            ${i}
        </button>
        `;
    }

    /* NEXT */
    html += `
    <button class="btn btn-sm btn-outline-primary"
        ${res.current_page === res.last_page ? 'disabled' : ''}
        onclick="loadInventoryTable(${res.current_page + 1})">
        Next &raquo;
    </button>
    `;

    html += '</div>';

    $('#inventoryPagination').html(html);
}


/* DELETE */
function deleteInventory(id) {

    if (!confirm('Delete this inventory?')) return;

    $.ajax({
        url: `/inventory/${id}`,
        type: 'POST',
        data: {
            _method: 'DELETE',
            _token: '<?php echo e(csrf_token()); ?>'
        },
        success: function () {
            alert('Deleted Successfully');
            loadInventoryTable(currentPage);
        }
    });
}
</script>




<script>
    /* ================================
   VIEW INVENTORY
================================ */
function viewInventory(id){
    $.get(`/inventory/${id}`, function(data){

        $('#viewInventoryBody').html(`

        <!-- PROPERTY INFO -->
        <div class="mb-3">
            <h6 class="fw-bold text-primary border-bottom pb-1">Property Information</h6>
            <div class="row g-2">
                <div class="col-md-4"><strong>Rm Name:</strong> ${data.rm_name ?? '-'}</div>
                <div class="col-md-4"><strong>Property Type:</strong> ${data.type ?? '-'}</div>
                <div class="col-md-4"><strong>Unit Address:</strong> ${data.unit_address ?? '-'}</div>
            </div>
        </div>

        <!-- LOCATION -->
        <div class="mb-3">
            <h6 class="fw-bold text-primary border-bottom pb-1">Location</h6>
            <div class="row g-2">
                <div class="col-md-4"><strong>State:</strong> ${data.state?.name ?? '-'}</div>
                <div class="col-md-4"><strong>City:</strong> ${data.city?.name ?? '-'}</div>
                <div class="col-md-4"><strong>Market:</strong> ${data.market?.name ?? '-'}</div>
            </div>
        </div>

        <!-- POC DETAILS -->
        <div class="mb-3">
            <h6 class="fw-bold text-primary border-bottom pb-1">POC Details</h6>
            <div class="row g-2">
                <div class="col-md-3"><strong>Name:</strong> ${data.poc_name ?? '-'}</div>
                <div class="col-md-3"><strong>Designation:</strong> ${data.designation ?? '-'}</div>
                <div class="col-md-3"><strong>Mobile:</strong> ${data.mobile ?? '-'}</div>
                <div class="col-md-3"><strong>Email:</strong> ${data.email ?? '-'}</div>
            </div>
        </div>

        <!-- PROPERTY DETAILS -->
        <div class="mb-3">
            <h6 class="fw-bold text-primary border-bottom pb-1">Property Details</h6>
            <div class="row g-2">
                <div class="col-md-3"><strong> Area (sq.ft.):</strong> ${data.area ?? '-'} sq.ft.</div>
                 <div class="col-md-3"><strong> Rate Per (sq.ft.):</strong> ${data.rate ?? '-'} sq.ft.</div>
                <div class="col-md-3"><strong>Floor:</strong> ${data.floor ?? '-'}</div>
                <div class="col-md-3"><strong>Frontage:</strong> ${data.frontage ?? '-'} Ft</div>
            </div>
        </div>

        <!-- STATUS -->
        <div class="mb-3">
            <h6 class="fw-bold text-primary border-bottom pb-1">Status</h6>
            <div class="row g-2">
                <div class="col-md-4"><strong>Availability:</strong> ${data.availability ?? '-'}</div>
                <div class="col-md-4"><strong>Current Tenant:</strong> ${data.current_brand ?? '-'}</div>
                <div class="col-md-4"><strong>Vacant Date:</strong> ${data.vacant_date ?? '-'}</div>
            </div>
        </div>

        <!-- IMAGE GALLERY -->
        <div class="mb-3">
            <h6 class="fw-bold text-primary border-bottom pb-1">Property Images</h6>
            <div class="row g-3 text-center">
                ${imageBox('Front View', data.front_view)}
                ${imageBox('Left View', data.left_view)}
                ${imageBox('Right View', data.right_view)}
                ${imageBox('Interior View', data.interior_view)}
            </div>
        </div>

        <!-- RENT -->
        <div class="text-end fw-bold fs-5 text-success border-top pt-2">
            Monthly Rent: ₹ ${data.monthly_rent ?? '-'}
        </div>
        `);

        $('#viewInventoryModal').modal('show');
    });
}
function imageBox(title, img){
    if(!img){
        return `
        <div class="col-md-3">
            <div class="border rounded p-3 text-muted small">
                No ${title}
            </div>
        </div>`;
    }

    return `
    <div class="col-md-3">
        <div class="border rounded p-2">
            <small class="fw-bold d-block mb-1">${title}</small>
            <img src="/storage/${img}"
                 class="img-fluid rounded"
                 style="height:140px;object-fit:cover">
        </div>
    </div>`;
}



</script>

<script>
function openEditInventory(id){

    $.get(`/inventory/${id}`, function(data){

        // FORM ACTION
        $('#editInventoryForm').attr('action', `/inventory/${id}`);

        // BASIC FIELDS
        $('#edit_type').val(data.type);
        $('#edit_rm_name').val(data.rm_name);

        $('#edit_unit_address').val(data.unit_address);
        $('#edit_area').val(data.area);
        $('#edit_rate').val(data.rate);
        $('#edit_rent').val(data.monthly_rent);

        /* ============================
           🔥 FIX STARTS HERE
        ============================ */

        // LOAD STATES + SET SELECTED
        $.get('/states', function(states){

            $('#edit_state').empty();

            states.forEach(state => {
                $('#edit_state').append(
                    `<option value="${state.id}" ${state.id == data.state_id ? 'selected' : ''}>
                        ${state.name}
                     </option>`
                );
            });

            // 🔥 VERY IMPORTANT FOR SELECT2
            $('#edit_state').trigger('change');

            // LOAD CITIES AFTER STATE
            $.get('/cities/' + data.state_id, function(cities){

                $('#edit_city').empty();

                cities.forEach(city => {
                    $('#edit_city').append(
                        `<option value="${city.id}" ${city.id == data.city_id ? 'selected' : ''}>
                            ${city.name}
                        </option>`
                    );
                });

                $('#edit_city').trigger('change');

                // LOAD MARKETS AFTER CITY
                $.get('/markets/' + data.city_id, function(markets){

                    $('#edit_market').empty();

                    markets.forEach(market => {
                        $('#edit_market').append(
                            `<option value="${market.id}" ${market.id == data.market_id ? 'selected' : ''}>
                                ${market.name}
                            </option>`
                        );
                    });

                    $('#edit_market').trigger('change');
                });
            });
        });

    
  // POC DETAILS ✅
        $('#edit_poc_name').val(data.poc_name);
         $('#edit_designation').val(data.designation);
       $('#edit_mobile').val(data.mobile);
        $('#edit_email').val(data.email);

        // RENT
        $('#edit_area').val(data.area);
        $('#edit_rate').val(data.rate);
        $('#edit_rent').val(data.monthly_rent);
          // ADDITIONAL
       // ✅ ADDITIONAL DETAILS (THIS WAS MISSING)
        $('#edit_floor').val(data.floor);
        $('#edit_frontage').val(data.frontage);
        $('#edit_availability').val(data.availability);
        $('#edit_current_brand').val(data.current_brand);

        // DATE FIX (yyyy-mm-dd required)
        if(data.vacant_date){
            $('#edit_vacant_date').val(data.vacant_date);
        }


// FRONT
$('#edit_front_preview').html(
    data.front_view
        ? `<img src="/storage/${data.front_view}" class="img-thumbnail" width="120">`
        : `<small class="text-muted">No image</small>`
);

// LEFT
$('#edit_left_preview').html(
    data.left_view
        ? `<img src="/storage/${data.left_view}" class="img-thumbnail" width="120">`
        : `<small class="text-muted">No image</small>`
);

// RIGHT
$('#edit_right_preview').html(
    data.right_view
        ? `<img src="/storage/${data.right_view}" class="img-thumbnail" width="120">`
        : `<small class="text-muted">No image</small>`
);

// INTERIOR
$('#edit_interior_preview').html(
    data.interior_view
        ? `<img src="/storage/${data.interior_view}" class="img-thumbnail" width="120">`
        : `<small class="text-muted">No image</small>`
);


        // SHOW MODAL
        $('#editInventoryModal').modal('show');
    });
}

// AUTO RENT CALC
$('#edit_area, #edit_rate').on('input', function(){
    let area = $('#edit_area').val() || 0;
    let rate = $('#edit_rate').val() || 0;
    $('#edit_rent').val(area * rate);
});
</script>
<script>
$(document).ready(function(){

    /* LOAD STATES */
    $.get('/states', function(states){
        $('#state').html('<option value="">Select State</option>');
        states.forEach(state => {
            $('#state').append(
                `<option value="${state.id}">${state.name}</option>`
            );
        });
    });

    /* LOAD CITIES */
    $('#state').on('change', function(){
        let stateId = this.value;

        $('#city').html('<option value="">Select City</option>');
        $('#market').html('<option value="">Select Market</option>');

        if(stateId){
            $.get('/cities/' + stateId, function(cities){
                cities.forEach(city => {
                    $('#city').append(
                        `<option value="${city.id}">${city.name}</option>`
                    );
                });
            });
        }
    });

    /* LOAD MARKETS */
    $('#city').on('change', function(){
        let cityId = this.value;

        $('#market').html('<option value="">Select Market</option>');

        if(cityId){
            $.get('/markets/' + cityId, function(markets){
                markets.forEach(market => {
                    $('#market').append(
                        `<option value="${market.id}">${market.name}</option>`
                    );
                });
            });
        }
    });

    /* AUTO RENT CALC */
    $('#area, #rate').on('input', function(){
        let area = $('#area').val() || 0;
        let rate = $('#rate').val() || 0;
        $('#rent').val(area * rate);
    });

});
</script>
<script>
/* ===============================
   EDIT INVENTORY DROPDOWNS
================================ */

$(document).ready(function(){

    // LOAD STATES FOR EDIT
    $.get('/states', function(states){
        $('#edit_state').html('<option value="">Select State</option>');
        states.forEach(state => {
            $('#edit_state').append(
                `<option value="${state.id}">${state.name}</option>`
            );
        });
    });

    // LOAD CITIES ON STATE CHANGE
    $('#edit_state').on('change', function(){
        let stateId = this.value;

        $('#edit_city').html('<option value="">Select City</option>');
        $('#edit_market').html('<option value="">Select Market</option>');

        if(stateId){
            $.get('/cities/' + stateId, function(cities){
                cities.forEach(city => {
                    $('#edit_city').append(
                        `<option value="${city.id}">${city.name}</option>`
                    );
                });
            });
        }
    });

    // LOAD MARKETS ON CITY CHANGE
    $('#edit_city').on('change', function(){
        let cityId = this.value;

        $('#edit_market').html('<option value="">Select Market</option>');

        if(cityId){
            $.get('/markets/' + cityId, function(markets){
                markets.forEach(market => {
                    $('#edit_market').append(
                        `<option value="${market.id}">${market.name}</option>`
                    );
                });
            });
        }
    });

});
</script>
<!-- //image name show// -->
<script>
function updateFileName(input, targetId) {

    let fileNameBox = document.getElementById(targetId);

    if (input.files && input.files.length > 0) {

        const file = input.files[0];
        const maxSize = 500 * 1024; // 500 KB

        // ❌ size check
        if (file.size > maxSize) {
            alert('❌ Image size must be less than 500 KB');

            // reset file input
            input.value = '';

            // hide filename box
            fileNameBox.style.display = 'none';
            fileNameBox.querySelector('span').innerText = '';

            return;
        }

        // ✅ valid file
        fileNameBox.style.display = 'block';
        fileNameBox.querySelector('span').innerText = file.name;

    } else {
        fileNameBox.style.display = 'none';
        fileNameBox.querySelector('span').innerText = '';
    }
}
</script>

<script>
    // state,city,market  reload automatically
function reloadStates(){
    $.get('/states', function(states){
        $('#state').html('<option value="">Select State</option>');
        states.forEach(s=>{
            $('#state').append(`<option value="${s.id}">${s.name}</option>`);
        });
    });
}

function reloadCities(stateId){
    $('#city').html('<option value="">Select City</option>');
    if(!stateId) return;

    $.get('/cities/' + stateId, function(cities){
        cities.forEach(c=>{
            $('#city').append(`<option value="${c.id}">${c.name}</option>`);
        });
    });
}

function reloadMarkets(cityId){
    $('#market').html('<option value="">Select Market</option>');
    if(!cityId) return;

    $.get('/markets/' + cityId, function(markets){
        markets.forEach(m=>{
            $('#market').append(`<option value="${m.id}">${m.name}</option>`);
        });
    });
}
</script>
<script>
// 🔥 LISTEN TO NAVBAR EVENTS

window.addEventListener('state-added', function(){
    console.log('State added event received');
    reloadStates();
});

window.addEventListener('city-added', function(){
    console.log('City added event received');
    let stateId = $('#state').val();
    if(stateId){
        reloadCities(stateId);
    }
});

window.addEventListener('market-added', function(){
    console.log('Market added event received');
    let cityId = $('#city').val();
    if(cityId){
        reloadMarkets(cityId);
    }
});
</script>
<script>
$(document).ready(function () {

    /* =========================
       CREATE FORM SELECT2
    ========================== */
    $('#state, #city, #market').select2({
        width: '100%',
        placeholder: 'Search...',
        allowClear: true
    });

    /* =========================
       EDIT MODAL SELECT2 (🔥 IMPORTANT)
    ========================== */
    $('#edit_state, #edit_city, #edit_market').select2({
        width: '100%',
        placeholder: 'Search...',
        allowClear: true,
        dropdownParent: $('#editInventoryModal') // 🔥 THIS IS THE FIX
    });

});
</script>

<script>
document.addEventListener('DOMContentLoaded', function () {

    const inventoryForm = document.querySelector('form[action="/inventory"]');

    if (inventoryForm) {
        inventoryForm.addEventListener('submit', function () {

            const submitBtn = inventoryForm.querySelector('.btn-submit');

            if (submitBtn) {
                submitBtn.disabled = true;            // 🔒 disable
                submitBtn.innerHTML = `
                    <i class="fas fa-spinner fa-spin"></i> Saving...
                `;
            }
        });
    }

});
</script>


<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ixapl/public_html/retailcrm.ixapl.com/resources/views/inventory/create.blade.php ENDPATH**/ ?>