<?php

namespace App\Http\Controllers;

use App\Models\BrandRequirement;
use Illuminate\Http\Request;

class BrandRequirementController extends Controller
{
    public function create()
    {
        return view('requirement.create', [
            'brands' => \App\Models\Brand::all(),
            'pocs'   => \App\Models\BrandPoc::all(),
        ]);
    }

    public function store(Request $r)
    {
        BrandRequirement::create(
            $r->validate([
                'brand_id'         => 'required',
                'brand_poc_id'     => 'required',
                'state_id'         => 'required',
                'city_id'          => 'required',
                'market_id'        => 'required',
                'budget'           => 'required',
                'type'             => 'required',
                'size_range'       => 'required',
                'floor_preference' => 'required',
                'timeline'         => 'required',
                'footage'          => 'required',
            ])
        );

        return back()->with('success', 'Requirement Added');
    }
public function list(Request $request)
{
    $requirements = BrandRequirement::with([
            'brand','poc','state','city','market'
        ])
        ->orderBy('id', 'desc')   // latest first
        ->paginate(15);            // per page (change if needed)

    return response()->json($requirements);
}



    /* ✅ SHOW (VIEW MODAL) */
    public function show($id)
    {
        return BrandRequirement::with([
            'brand','poc','state','city','market'
        ])->findOrFail($id);
    }

public function update(Request $request, $id)
{
    $validated = $request->validate(
        [
            'brand_id'         => 'required',
            'brand_poc_id'     => 'required',
            'state_id'         => 'required',
            'city_id'          => 'required',
            'market_id'        => 'required',
            'budget'           => 'required',
            'type'             => 'required',
            'size_range'       => 'required',
            'floor_preference' => 'required',
            'timeline'         => 'required',
            'footage'          => 'required',
        ],
        [
            'brand_id.required'         => 'Brand is required',
            'brand_poc_id.required'     => 'Brand POC is required',
            'state_id.required'         => 'State is required',
            'city_id.required'          => 'City is required',
            'market_id.required'        => 'Market is required',
            'budget.required'           => 'Budget is required',
            'type.required'             => 'Type is required',
            'size_range.required'       => 'Size Range is required',
            'floor_preference.required' => 'Floor Preference is required',
            'timeline.required'         => 'Timeline is required',
            'footage.required'          => 'Footage is required',
        ]
    );

    $req = BrandRequirement::findOrFail($id);
    $req->update($validated);

    return response()->json([
        'success' => true,
        'message' => 'Requirement updated successfully'
    ]);
}

public function destroy($id)
{
    $req = BrandRequirement::findOrFail($id);
    $req->delete();

    return response()->json([
        'success' => true
    ]);
}




}
