<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('opportunities', function (Blueprint $table) {
            $table->id();

            $table->foreignId('inventory_id')->constrained()->cascadeOnDelete();
            $table->foreignId('brand_requirement_id')->constrained()->cascadeOnDelete();

            $table->foreignId('market_id');
            $table->string('inventory_type');
            $table->integer('monthly_rent');

            $table->string('status')->default('open'); // open / contacted / closed

            $table->timestamps();

            // prevent duplicate opportunity
            $table->unique(['inventory_id','brand_requirement_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('opportunities');
    }
};
