<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class BrandRequirement extends Model
{
   protected $fillable = [
            'brand_id',
            'brand_poc_id',
            'state_id',
            'city_id',
            'market_id',
            'budget',
            'type',
            'size_range',
            'floor_preference',
            'timeline',
            'footage'
];
public function brand(){
    return $this->belongsTo(\App\Models\Brand::class);
}

public function poc(){
    return $this->belongsTo(\App\Models\BrandPoc::class,'brand_poc_id');
}

public function state(){
    return $this->belongsTo(\App\Models\State::class);
}

public function city(){
    return $this->belongsTo(\App\Models\City::class);
}

public function market(){
    return $this->belongsTo(\App\Models\Market::class);
}

public function inventory()
{
    return $this->hasOne(
        \App\Models\Inventory::class,
        'market_id',
        'market_id'
    );
}

}
