
<?php $__env->startSection('title','Opportunities'); ?>

<?php $__env->startSection('content'); ?>

<!-- ================= CDN ================= -->
 <link rel="stylesheet"
 href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">

<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>

<!-- Select2 -->
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet"/>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<!-- Date Range Picker -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css"/>
<script src="https://cdn.jsdelivr.net/npm/moment@2.29.4/moment.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>



<div class="container">
    

<div class="row g-4 mb-4">

    <div class="col-6 col-md-2">
        <div class="card text-center ">
            <h6 class="mt-2">Today</h6>
            <h4 class="fw-bold text-primary"><?php echo e($todayCount); ?></h4>
        </div>
    </div>

    <div class="col-6 col-md-2">
        <div class="card text-center ">
            <h6 class="mt-2">Yesterday</h6>
            <h4 class="fw-bold text-danger"><?php echo e($yesterdayCount); ?></h4>
        </div>
    </div>

    <div class="col-6 col-md-2">
        <div class="card text-center">
            <h6 class="mt-2">Week</h6>
            <h4 class="fw-bold text-warning"><?php echo e($weekCount); ?></h4>
        </div>
    </div>

    <div class="col-6 col-md-2">
        <div class="card text-center ">
            <h6 class="mt-2">Month</h6>
            <h4 class="fw-bold text-success"><?php echo e($monthCount); ?></h4>
        </div>
    </div>

    <div class="col-6 col-md-2">
        <div class="card text-center ">
            <h6 class="mt-2">Year</h6>
            <h4 class="fw-bold text-info"><?php echo e($yearCount); ?></h4>
        </div>
    </div>

    <div class="col-6 col-md-2">
        <div class="card text-center shadow-sm border-primary">
            <h6 class="mt-2">Total</h6>
            <h4 class="fw-bold text-dark"><?php echo e($totalCount); ?></h4>
        </div>
    </div>

</div>

    <div class="row">

        <!-- ================= LEFT FILTER ================= -->
        <div class="col-md-3">
            <form method="GET" action="<?php echo e(route('opportunities.index')); ?>">

                <div class="card filter-card mb-4">
                    <div class="card-header">
                        <i class="fas fa-filter me-2"></i>Filters
                    </div>

                    <div class="card-body">

                        <!-- CITY -->
                        <div class="mb-3">
                           <label class="form-label">
    <i class="fas fa-city me-2 text-primary"></i> City
</label>

                            <select name="cities[]" id="cities"
                                    class="form-select select2"
                                    multiple
                                    data-placeholder="Search city">
                                <?php $__currentLoopData = \App\Models\City::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $city): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($city->id); ?>"
                                        <?php echo e(in_array($city->id, request('cities', [])) ? 'selected' : ''); ?>>
                                        <?php echo e($city->name); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <!-- MARKET -->
                        <div class="mb-3">
                            <label class="form-label">
    <i class="fas fa-store me-2 text-primary"></i> Market
</label>

                            <select name="markets[]" id="markets"
                                    class="form-select select2"
                                    multiple
                                    data-placeholder="Search market">
                                <?php $__currentLoopData = \App\Models\Market::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $market): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($market->id); ?>"
                                        <?php echo e(in_array($market->id, request('markets', [])) ? 'selected' : ''); ?>>
                                        <?php echo e($market->name); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <!-- DATE -->
                        <div class="mb-4">
                          <label class="form-label">
    <i class="fas fa-calendar-alt me-2 text-primary"></i>
    Date Range
</label>

                            <div class="input-group">
                                <span class="input-group-text">
                                    <i class="fas fa-calendar-alt"></i>
                                </span>
                                <input type="text"
                                       id="dateRange"
                                       class="form-control"
                                       placeholder="Select date range"
                                       readonly
                                       style="background:#fff; cursor:pointer;">
                            </div>

                            <input type="hidden" name="date_filter" id="date_filter" value="<?php echo e(request('date_filter')); ?>">
                            <input type="hidden" name="date_from"   id="date_from"   value="<?php echo e(request('date_from')); ?>">
                            <input type="hidden" name="date_to"     id="date_to"     value="<?php echo e(request('date_to')); ?>">
                        </div>

                        <button type="submit" class="btn btn-primary w-100 mb-2">

                            <i class="fas fa-search me-2"></i>Apply Filters
                        </button>

                        <a href="<?php echo e(route('opportunities.index')); ?>"
                           class="btn btn-outline-secondary w-100">
                            <i class="fas fa-redo me-2"></i>Reset Filters
                        </a>  



                        <button type="submit" name="export" value="excel"
        class="btn btn-warning
         w-100 mt-2">
    <i class="fas fa-file-excel me-2"></i>Download Excel
</button>


                    </div>
                </div>
            </form>
        </div>

        <!-- ================= RIGHT TABLE ================= -->
        <div class="col-md-9">

            <div class="card table-card">
                <div class="card-body">

                    <div class="table-responsive">
   
        <h3 class="text-center pt-3">Matched Opportunities</h3>
       
    

                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th width="80">SR.No.</th>
                                    <th>Brand</th>
                                    <th>Market</th>
                                    <th width="120">Actions</th>
                                </tr>
                            </thead>

                            <tbody>
                                <?php
                                $start = $opportunities->total()
                                        - (($opportunities->currentPage() - 1)
                                        * $opportunities->perPage());
                                ?>

                                <?php $__empty_1 = true; $__currentLoopData = $opportunities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $op): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><strong><?php echo e($start - $i); ?></strong></td>
                                        <td><?php echo e($op->brand->name ?? '-'); ?></td>
                                        <td><?php echo e($op->market->name ?? '-'); ?></td>
                                        <td>
                                            <button class="btn btn-primary btn-sm"
                                                    onclick="viewOpportunity(<?php echo e($op->id); ?>)">
                                                <i class="fas fa-eye me-1"></i>View
                                            </button>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="4" class="empty-state">
                                            <i class="fas fa-inbox"></i>
                                            <p class="mb-0"><strong>No opportunities found</strong></p>
                                            <small>Try adjusting your filters to see more results</small>
                                        </td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>

                    <?php if($opportunities->hasPages()): ?>
                        <div class="d-flex justify-content-center">
                            <?php echo e($opportunities->appends(request()->query())->links()); ?>

                        </div>
                    <?php endif; ?>

                </div>
            </div>

        </div>
    </div>
</div>

<?php echo $__env->make('opportunities.modal', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<!-- ================= JS ================= -->
<script>
$(document).ready(function () {

    /* ===== SELECT2 ===== */
    $('.select2').select2({
        width: '100%',
        closeOnSelect: false,
        placeholder: function () {
            return $(this).data('placeholder');
        }
    });

    /* ===== DATE RANGE PICKER ===== */
    $('#dateRange').daterangepicker({
        autoUpdateInput: false,
        opens: 'left',
        ranges: {
            'Today': [moment(), moment()],
            'Yesterday': [
                moment().subtract(1,'days'),
                moment().subtract(1,'days')
            ],
            'Last 7 Days': [
                moment().subtract(6,'days'),
                moment()
            ],
            'Last 30 Days': [
                moment().subtract(29,'days'),
                moment()
            ],
            'This Month': [
                moment().startOf('month'),
                moment().endOf('month')
            ],
            'Last Month': [
                moment().subtract(1,'month').startOf('month'),
                moment().subtract(1,'month').endOf('month')
            ]
        }
    }, function (start, end, label) {

        $('#date_from').val(start.format('YYYY-MM-DD'));
        $('#date_to').val(end.format('YYYY-MM-DD'));

        if (label === 'Today' || label === 'Yesterday') {
            $('#date_filter').val(label.toLowerCase());
            $('#dateRange').val(label);
        } else {
            $('#date_filter').val('');
            $('#dateRange').val(
                start.format('MMMM D, YYYY') +
                ' - ' +
                end.format('MMMM D, YYYY')
            );
        }
    });

    /* ===== Restore date text after reload ===== */
    const from = $('#date_from').val();
    const to   = $('#date_to').val();
    if (from && to) {
        $('#dateRange').val(
            moment(from).format('MMMM D, YYYY') +
            ' - ' +
            moment(to).format('MMMM D, YYYY')
        );
    }
});
</script>
<script>
$(document).ready(function () {

    $('.select2').select2({
        width: '100%',
        closeOnSelect: false,
        placeholder: function () {
            return $(this).data('placeholder');
        }
    });

    // 🔥 FORCE select2 values into form on submit
    $('form').on('submit', function () {
        $('#cities').val($('#cities').val());
        $('#markets').val($('#markets').val());
    });
});
</script>


<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\AT\Desktop\retail-crm\resources\views/opportunities/index.blade.php ENDPATH**/ ?>