<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Welcome Back</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

       body {
    height: 100vh;
    margin: 0;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;

    display: flex;
    align-items: center;
    justify-content: center;

    overflow: hidden; /* 🔥 page scroll band */
}
.login-container {
    position: fixed;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);

    background: white;
    border-radius: 18px;
    box-shadow: 0 18px 45px rgba(0, 0, 0, 0.25);

    max-width: 820px;   /* 🔥 pehle 1000px tha */
    width: 90%;
    max-height: 85vh;   /* 🔥 height control */

    display: flex;
    overflow: hidden;
}


        .login-left {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            padding: 40px 30px;
            color: white;
            flex: 1;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            text-align: center;
        }

        .login-left h2 {
            font-size: 2.5rem;
            font-weight: 700;
            margin-bottom: 20px;
        }

        .login-left p {
            font-size: 1.1rem;
            opacity: 0.9;
            line-height: 1.6;
        }

        .login-left i {
            font-size: 100px;
            margin-bottom: 30px;
            opacity: 0.9;
        }

.login-right {
    padding: 40px 40px;   /* 🔥 padding kam */
    flex: 1;

    display: flex;
    flex-direction: column;
    justify-content: flex-start; /* 🔥 center ❌ */

    overflow-y: auto;     /* 🔥 agar content zyada ho */
}


        .login-header {
            margin-bottom: 40px;
        }

        .login-header h3 {
            font-size: 2rem;
            font-weight: 700;
            color: #333;
            margin-bottom: 10px;
        }

        .login-header p {
            color: #666;
            font-size: 0.95rem;
        }

        .form-group {
            margin-bottom: 25px;
            position: relative;
        }

        .form-group label {
            display: block;
            margin-bottom: 8px;
            color: #333;
            font-weight: 600;
            font-size: 0.9rem;
        }

        .input-group-custom {
            position: relative;
        }

        .input-group-custom i {
            position: absolute;
            left: 15px;
            top: 50%;
            transform: translateY(-50%);
            color: #667eea;
            font-size: 1.1rem;
        }

        .form-control-custom {
            width: 100%;
            padding: 15px 15px 15px 45px;
            border: 2px solid #e1e8ed;
            border-radius: 10px;
            font-size: 1rem;
            transition: all 0.3s ease;
            outline: none;
        }

        .form-control-custom:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        }

        .btn-login {
            width: 100%;
            padding: 15px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            border-radius: 10px;
            color: white;
            font-size: 1.1rem;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            margin-top: 10px;
        }

        .btn-login:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 20px rgba(102, 126, 234, 0.3);
        }

        .alert-custom {
            padding: 15px 20px;
            border-radius: 10px;
            margin-bottom: 25px;
            border-left: 4px solid #dc3545;
            background-color: #f8d7da;
            color: #721c24;
            display: flex;
            align-items: center;
        }

        .alert-custom i {
            margin-right: 10px;
            font-size: 1.2rem;
        }

        .divider {
            text-align: center;
            margin: 30px 0;
            position: relative;
        }

        .divider::before {
            content: '';
            position: absolute;
            left: 0;
            top: 50%;
            width: 100%;
            height: 1px;
            background: #e1e8ed;
        }

        .divider span {
            background: white;
            padding: 0 15px;
            color: #999;
            position: relative;
            z-index: 1;
        }

        .register-link {
            text-align: center;
            margin-top: 30px;
            color: #666;
        }

        .register-link a {
            color: #667eea;
            text-decoration: none;
            font-weight: 600;
            transition: color 0.3s ease;
        }

        .register-link a:hover {
            color: #764ba2;
        }

        .change-password {
            text-align: right;
            margin-top: 10px;
        }

        .change-password a {
            color: #667eea;
            text-decoration: none;
            font-size: 0.9rem;
            transition: color 0.3s ease;
        }

        .forgot-password a:hover {
            color: #764ba2;
        }

        @media (max-width: 768px) {
            .login-container {
                flex-direction: column;
            }

            .login-left {
                padding: 40px 30px;
                display: none;
            }

            .login-right {
                padding: 40px 30px;
            }

            .login-header h3 {
                font-size: 1.75rem;
            }

            .login-left h2 {
                font-size: 2rem;
            }

            .login-left i {
                font-size: 80px;
            }
        }

        @media (max-width: 480px) {
            body {
                padding: 10px;
            }

            .login-right {
                padding: 30px 20px;
            }

            .login-header h3 {
                font-size: 1.5rem;
            }

            .form-control-custom {
                padding: 12px 12px 12px 40px;
            }

            .btn-login {
                padding: 12px;
                font-size: 1rem;
            }
        }
    </style>
</head>
<body>
<div class="login-container">
    <div class="login-left">
        <i class="fas fa-lock" style="color: #ffde3b;"
></i>
        <h2>Welcome Back!</h2>
        <p>Enter your credentials to access your account and continue your journey with us.</p>
    </div>

    <div class="login-right">
        <div class="login-header">
            <h3>Sign In</h3>
            <p>Login to your account to continue</p>
        </div>

        <?php if(session('error')): ?>
        <div class="alert-custom">
            <i class="fas fa-exclamation-circle"></i>
            <span><?php echo e(session('error')); ?></span>
        </div>
        <?php endif; ?>

        <form method="POST" action="/login">
            <?php echo csrf_field(); ?>
            
            <div class="form-group">
                <label for="email">Email Address</label>
                <div class="input-group-custom">
                    <i class="fas fa-envelope"></i>
                    <input type="email" 
                           id="email" 
                           name="email" 
                           class="form-control-custom" 
                           placeholder="Enter your email"
                           required>
                </div>
            </div>

            <div class="form-group">
                <label for="password">Password</label>
                <div class="input-group-custom">
                    <i class="fas fa-lock"></i>
                    <input type="password" 
                           id="password" 
                           name="password" 
                           class="form-control-custom" 
                           placeholder="Enter your password"
                           required>
                </div>
              
            </div>

            <button type="submit" class="btn-login">
                Sign In
            </button>
        </form>

 
    </div>
</div>

</body>
</html><?php /**PATH C:\Users\AT\Desktop\retail-crm\resources\views/auth/login.blade.php ENDPATH**/ ?>