<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Password Change</title>

    <!-- Font Awesome -->
    <link rel="stylesheet"
          href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">

    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            min-height: 100vh;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            font-family: 'Segoe UI', sans-serif;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }

        .login-container {
            background: white;
            border-radius: 18px;
            box-shadow: 0 18px 45px rgba(0, 0, 0, 0.25);
            width: 100%;
            max-width: 850px;
            display: flex;
            overflow: hidden;
        }

        .login-left {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            padding: 60px 40px;
            color: white;
            flex: 1;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            text-align: center;
            min-width: 350px;
        }

        .login-left i {
            font-size: 90px;
            margin-bottom: 25px;
            color: #ffde3b;
        }

        .login-left h2 {
            font-size: 2.3rem;
            margin-bottom: 15px;
            font-weight: 700;
        }

        .login-left p {
            opacity: 0.9;
            line-height: 1.6;
            font-size: 1rem;
        }

        .login-right {
            flex: 1;
            padding: 50px 45px;
            display: flex;
            flex-direction: column;
            justify-content: center;
            overflow-y: auto;
            max-height: 90vh;
        }

        .login-header {
            margin-bottom: 35px;
        }

        .login-header h3 {
            font-size: 2rem;
            font-weight: 700;
            margin-bottom: 8px;
            color: #333;
        }

        .login-header p {
            color: #666;
            font-size: 0.95rem;
        }

        .form-group {
            margin-bottom: 25px;
        }

        .form-group label {
            display: block;
            margin-bottom: 8px;
            font-weight: 600;
            color: #333;
            font-size: 0.95rem;
        }

        .input-group-custom {
            position: relative;
        }

        .input-group-custom i {
            position: absolute;
            left: 15px;
            top: 50%;
            transform: translateY(-50%);
            color: #667eea;
            font-size: 1rem;
        }

        .form-control-custom {
            width: 100%;
            padding: 14px 14px 14px 45px;
            border-radius: 10px;
            border: 2px solid #e1e8ed;
            font-size: 1rem;
            outline: none;
            transition: all 0.3s ease;
            font-family: 'Segoe UI', sans-serif;
        }

        .form-control-custom:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 3px rgba(102,126,234,.15);
        }

        .btn-login {
            width: 100%;
            padding: 15px;
            border-radius: 10px;
            border: none;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            font-size: 1.1rem;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            margin-top: 10px;
        }

        .btn-login:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 20px rgba(102,126,234,.3);
        }

        .btn-login:active {
            transform: translateY(0);
        }

        .alert-custom {
            display: flex;
            align-items: center;
            padding: 15px 20px;
            border-radius: 10px;
            margin-bottom: 25px;
            border-left: 4px solid #dc3545;
            background: #f8d7da;
            color: #721c24;
            font-size: 0.95rem;
        }

        .alert-custom i {
            margin-right: 10px;
            font-size: 1.1rem;
        }

        .alert-success {
            border-left-color: #28a745;
            background: #d4edda;
            color: #155724;
        }

        .register-link {
            text-align: center;
            margin-top: 30px;
            color: #666;
            font-size: 0.95rem;
        }

        .register-link a {
            color: #667eea;
            font-weight: 600;
            text-decoration: none;
            transition: color 0.3s ease;
        }

        .register-link a:hover {
            color: #764ba2;
            text-decoration: underline;
        }

        /* ================= TABLET (768px - 992px) ================= */
        @media (max-width: 992px) {
            .login-container {
                max-width: 700px;
            }

            .login-left {
                min-width: 280px;
                padding: 40px 30px;
            }

            .login-left i {
                font-size: 70px;
                margin-bottom: 20px;
            }

            .login-left h2 {
                font-size: 1.8rem;
                margin-bottom: 12px;
            }

            .login-left p {
                font-size: 0.9rem;
            }

            .login-right {
                padding: 40px 35px;
            }

            .login-header h3 {
                font-size: 1.7rem;
            }
        }

        /* ================= MOBILE (MAX 768px) ================= */
        @media (max-width: 768px) {
            body {
                padding: 15px;
                align-items: flex-start;
                padding-top: 30px;
            }

            .login-container {
                flex-direction: column;
                border-radius: 16px;
                max-width: 100%;
            }

            .login-left {
                display: none;
            }

            .login-right {
                padding: 35px 30px;
                max-height: none;
                overflow-y: visible;
            }

            .login-header {
                margin-bottom: 30px;
            }

            .login-header h3 {
                font-size: 1.75rem;
            }

            .login-header p {
                font-size: 0.9rem;
            }

            .form-group {
                margin-bottom: 20px;
            }

            .form-control-custom {
                padding: 13px 13px 13px 43px;
            }

            .btn-login {
                padding: 14px;
                font-size: 1.05rem;
            }

            .register-link {
                margin-top: 25px;
            }
        }

        /* ================= SMALL MOBILE (MAX 576px) ================= */
        @media (max-width: 576px) {
            body {
                padding: 10px;
                padding-top: 20px;
            }

            .login-container {
                border-radius: 14px;
                box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
            }

            .login-right {
                padding: 28px 22px;
            }

            .login-header {
                margin-bottom: 25px;
            }

            .login-header h3 {
                font-size: 1.6rem;
            }

            .login-header p {
                font-size: 0.88rem;
            }

            .form-group {
                margin-bottom: 18px;
            }

            .form-group label {
                font-size: 0.9rem;
                margin-bottom: 6px;
            }

            .form-control-custom {
                padding: 12px 12px 12px 42px;
                font-size: 0.95rem;
                border-radius: 8px;
            }

            .input-group-custom i {
                left: 13px;
                font-size: 0.95rem;
            }

            .btn-login {
                padding: 13px;
                font-size: 1rem;
                border-radius: 8px;
                margin-top: 8px;
            }

            .alert-custom {
                font-size: 0.88rem;
                padding: 12px 15px;
                border-radius: 8px;
                margin-bottom: 20px;
            }

            .alert-custom i {
                font-size: 1rem;
                margin-right: 8px;
            }

            .register-link {
                margin-top: 20px;
                font-size: 0.88rem;
            }
        }

        /* ================= EXTRA SMALL MOBILE (MAX 400px) ================= */
        @media (max-width: 400px) {
            body {
                padding: 8px;
                padding-top: 15px;
            }

            .login-right {
                padding: 25px 18px;
            }

            .login-header h3 {
                font-size: 1.5rem;
            }

            .login-header p {
                font-size: 0.85rem;
            }

            .form-group {
                margin-bottom: 16px;
            }

            .form-group label {
                font-size: 0.88rem;
            }

            .form-control-custom {
                padding: 11px 11px 11px 40px;
                font-size: 0.92rem;
            }

            .input-group-custom i {
                left: 12px;
                font-size: 0.9rem;
            }

            .btn-login {
                padding: 12px;
                font-size: 0.98rem;
            }
        }

        /* ================= LARGE DESKTOP (MIN 1200px) ================= */
        @media (min-width: 1200px) {
            .login-container {
                max-width: 900px;
            }

            .login-left {
                min-width: 380px;
                padding: 70px 50px;
            }

            .login-left i {
                font-size: 100px;
            }

            .login-left h2 {
                font-size: 2.5rem;
            }

            .login-right {
                padding: 60px 50px;
            }

            .login-header h3 {
                font-size: 2.2rem;
            }

            .form-control-custom {
                padding: 15px 15px 15px 48px;
            }

            .btn-login {
                padding: 16px;
                font-size: 1.15rem;
            }
        }

        /* ================= SMOOTH SCROLLING ================= */
        @media (max-height: 700px) and (min-width: 769px) {
            .login-right {
                max-height: 85vh;
                overflow-y: auto;
            }

            .login-right::-webkit-scrollbar {
                width: 6px;
            }

            .login-right::-webkit-scrollbar-track {
                background: #f1f1f1;
                border-radius: 10px;
            }

            .login-right::-webkit-scrollbar-thumb {
                background: #667eea;
                border-radius: 10px;
            }

            .login-right::-webkit-scrollbar-thumb:hover {
                background: #764ba2;
            }
        }
    </style>
</head>
<body>

<div class="login-container">

    <div class="login-left">
        <i class="fas fa-lock"></i>
        <h2>Welcome Back!</h2>
        <p>Enter your credentials to access your account and continue your journey with us.</p>
    </div>

    <div class="login-right">

        <div class="login-header">
            <h3>Password Change</h3>
            <p>Let's change my password</p>
        </div>

        <?php if(session('error')): ?>
            <div class="alert-custom">
                <i class="fas fa-exclamation-circle"></i>
                <?php echo e(session('error')); ?>

            </div>
        <?php endif; ?>

        <?php if(session('success')): ?>
            <div class="alert-custom alert-success">
                <i class="fas fa-check-circle"></i>
                <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>

        <form method="POST" action="/change-password">
            <?php echo csrf_field(); ?>

            <div class="form-group">
                <label>Email</label>
                <div class="input-group-custom">
                    <i class="fas fa-envelope"></i>
                    <input type="email" name="email" class="form-control-custom" required>
                </div>
            </div>

            <div class="form-group">
                <label>Old Password</label>
                <div class="input-group-custom">
                    <i class="fas fa-lock"></i>
                    <input type="password" name="old_password" class="form-control-custom" required>
                </div>
            </div>

            <div class="form-group">
                <label>New Password</label>
                <div class="input-group-custom">
                    <i class="fas fa-key"></i>
                    <input type="password" name="new_password" class="form-control-custom" required>
                </div>
            </div>

            <div class="form-group">
                <label>Confirm New Password</label>
                <div class="input-group-custom">
                    <i class="fas fa-check-circle"></i>
                    <input type="password" name="new_password_confirmation" class="form-control-custom" required>
                </div>
            </div>

            <button type="submit" class="btn-login">
                Update Password
            </button>
        </form>

        <div class="register-link">
            Go to login page <a href="/login">Login</a>
        </div>

    </div>
</div>

</body>
</html><?php /**PATH C:\Users\AT\Desktop\retail-crm\resources\views/auth/change-password.blade.php ENDPATH**/ ?>