<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Register - Create Account</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }

        .register-container {
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
            overflow: hidden;
            max-width: 1000px;
            width: 100%;
            display: flex;
            flex-direction: row;
        }

        .register-left {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            padding: 60px 40px;
            color: white;
            flex: 1;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            text-align: center;
        }

        .register-left h2 {
            font-size: 2.5rem;
            font-weight: 700;
            margin-bottom: 20px;
        }

        .register-left p {
            font-size: 1.1rem;
            opacity: 0.9;
            line-height: 1.6;
        }

        .register-left i {
            font-size: 100px;
            margin-bottom: 30px;
            opacity: 0.9;
        }

        .register-right {
            padding: 60px 50px;
            flex: 1;
            display: flex;
            flex-direction: column;
            justify-content: center;
        }

        .register-header {
            margin-bottom: 40px;
        }

        .register-header h3 {
            font-size: 2rem;
            font-weight: 700;
            color: #333;
            margin-bottom: 10px;
        }

        .register-header p {
            color: #666;
            font-size: 0.95rem;
        }

        .form-group {
            margin-bottom: 25px;
            position: relative;
        }

        .form-group label {
            display: block;
            margin-bottom: 8px;
            color: #333;
            font-weight: 600;
            font-size: 0.9rem;
        }

        .input-group-custom {
            position: relative;
        }

        .input-group-custom i {
            position: absolute;
            left: 15px;
            top: 50%;
            transform: translateY(-50%);
            color: #667eea;
            font-size: 1.1rem;
        }

        .form-control-custom {
            width: 100%;
            padding: 15px 15px 15px 45px;
            border: 2px solid #e1e8ed;
            border-radius: 10px;
            font-size: 1rem;
            transition: all 0.3s ease;
            outline: none;
        }

        .form-control-custom:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        }

        .btn-register {
            width: 100%;
            padding: 15px;
            background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%);
            border: none;
            border-radius: 10px;
            color: white;
            font-size: 1.1rem;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            margin-top: 10px;
        }

        .btn-register:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 20px rgba(17, 153, 142, 0.3);
        }

        .alert-custom {
            padding: 15px 20px;
            border-radius: 10px;
            margin-bottom: 25px;
            border-left: 4px solid #dc3545;
            background-color: #f8d7da;
            color: #721c24;
            display: flex;
            align-items: center;
        }

        .alert-custom i {
            margin-right: 10px;
            font-size: 1.2rem;
        }

        .login-link {
            text-align: center;
            margin-top: 30px;
            color: #666;
        }

        .login-link a {
            color: #667eea;
            text-decoration: none;
            font-weight: 600;
            transition: color 0.3s ease;
        }

        .login-link a:hover {
            color: #764ba2;
        }

        .password-strength {
            margin-top: 8px;
            font-size: 0.85rem;
        }

        .strength-bar {
            height: 4px;
            background: #e1e8ed;
            border-radius: 2px;
            overflow: hidden;
            margin-top: 5px;
        }

        .strength-bar-fill {
            height: 100%;
            width: 0%;
            transition: all 0.3s ease;
        }

        .strength-weak { 
            width: 33%; 
            background: #dc3545; 
        }

        .strength-medium { 
            width: 66%; 
            background: #ffc107; 
        }

        .strength-strong { 
            width: 100%; 
            background: #28a745; 
        }

        .terms {
            margin-top: 20px;
            font-size: 0.85rem;
            color: #666;
            text-align: center;
            line-height: 1.5;
        }

        .terms a {
            color: #667eea;
            text-decoration: none;
        }

        .terms a:hover {
            text-decoration: underline;
        }

        @media (max-width: 768px) {
            .register-container {
                flex-direction: column;
            }

            .register-left {
                padding: 40px 30px;
                display: none;
            }

            .register-right {
                padding: 40px 30px;
            }

            .register-header h3 {
                font-size: 1.75rem;
            }

            .register-left h2 {
                font-size: 2rem;
            }

            .register-left i {
                font-size: 80px;
            }
        }

        @media (max-width: 480px) {
            body {
                padding: 10px;
            }

            .register-right {
                padding: 30px 20px;
            }

            .register-header h3 {
                font-size: 1.5rem;
            }

            .form-control-custom {
                padding: 12px 12px 12px 40px;
            }

            .btn-register {
                padding: 12px;
                font-size: 1rem;
            }
        }
    </style>
</head>
<body>

<div class="register-container">
    <div class="register-left">
        <i class="fas fa-user-plus"></i>
        <h2>Join Us Today!</h2>
        <p>Create your account and start your amazing journey with us. It only takes a minute to get started.</p>
    </div>

    <div class="register-right">
        <div class="register-header">
            <h3>Create Account</h3>
            <p>Sign up to get started</p>
        </div>

        <?php if(session('error')): ?>
        <div class="alert-custom">
            <i class="fas fa-exclamation-circle"></i>
            <span><?php echo e(session('error')); ?></span>
        </div>
        <?php endif; ?>

        <form method="POST" action="/register">
            <?php echo csrf_field(); ?>
            
            <div class="form-group">
                <label for="name">Full Name</label>
                <div class="input-group-custom">
                    <i class="fas fa-user"></i>
                    <input type="text" 
                           id="name" 
                           name="name" 
                           class="form-control-custom" 
                           placeholder="Enter your full name"
                           required>
                </div>
            </div>

            <div class="form-group">
                <label for="email">Email Address</label>
                <div class="input-group-custom">
                    <i class="fas fa-envelope"></i>
                    <input type="email" 
                           id="email" 
                           name="email" 
                           class="form-control-custom" 
                           placeholder="Enter your email"
                           required>
                </div>
            </div>

            <div class="form-group">
                <label for="password">Password</label>
                <div class="input-group-custom">
                    <i class="fas fa-lock"></i>
                    <input type="password" 
                           id="password" 
                           name="password" 
                           class="form-control-custom" 
                           placeholder="Create a strong password"
                           required>
                </div>
            </div>
            <div class="form-group">
    <label>User Role</label>
    <div class="input-group-custom">
        <i class="fas fa-user-shield"></i>
        <select name="role" class="form-control-custom" required>
            <option value="">-- Select Role --</option>
            <option value="admin">Admin</option>
            <option value="operation">Operation</option>
            <option value="supervisor">Supervisor</option>
            <option value="sales">Sales</option>
        </select>
    </div>
</div>


            <button type="submit" class="btn-register">
                Create Account
            </button>

            <div class="terms">
                By signing up, you agree to our <a href="/terms">Terms of Service</a> and <a href="/privacy">Privacy Policy</a>
            </div>
        </form>

        <div class="login-link">
            Already have an account? <a href="/login">Sign In</a>
        </div>
    </div>
</div>

</body>
</html><?php /**PATH C:\Users\AT\Desktop\retail-crm\resources\views/auth/register.blade.php ENDPATH**/ ?>