<style>
    .modal-body table {
        min-width: 269px;
    }
</style>

<!-- NAVBAR -->
<nav class="navbar navbar-custom">
    <div class="container-fluid d-flex justify-content-between align-items-center">

        <!-- LEFT : BRAND -->
        <a href="/dashboard" style="text-decoration: none;">
            <span class="navbar-brand-custom">
                <i class="fas fa-store"></i> Leasing CRM
            </span>
        </a>

        <!-- RIGHT : ALL BUTTONS IN ONE LINE -->
        <div class="d-flex align-items-center gap-1 flex-nowrap overflow-auto">

            <a href="/inventory" class="btn btn-primary flex-shrink-0">
                📦 Inventory
            </a>

            <a href="/brands" class="btn btn-success flex-shrink-0">
                🏷️ Brand
            </a>

            <a href="/brand-poc" class="btn btn-primary flex-shrink-0">
                👤 Brand POC
            </a>

            <a href="/requirements" class="btn btn-success flex-shrink-0">
                📋 Requirement
            </a>

            <!-- <a href="{{ route('opportunities.index') }}" class="btn btn-primary flex-shrink-0">
                🎯 Opportunities
            </a> -->

            <!-- USER NAME -->
            <!-- <span class="text-white fw-semibold flex-shrink-0 ms-2">
                Hi, {{ auth()->user()->name }}
            </span> -->

            <!-- USERS BUTTON -->
            @if(auth()->user()->role === 'admin')
            <a href="/admin/users" class="btn btn-logout flex-shrink-0">
                <i class="fas fa-users-cog"></i> Users
            </a>
            @endif

            <!-- SETTINGS -->
            <button class="btn btn-logout flex-shrink-0"
                    data-bs-toggle="modal"
                    data-bs-target="#settingsModal">
                <i class="fas fa-cog"></i> Settings
            </button>

            <!-- LOGOUT -->
            <form method="POST" action="/logout" class="flex-shrink-0">
                @csrf
                <button class="btn btn-logout">
                    <i class="fas fa-sign-out-alt"></i> Logout
                </button>
            </form>

        </div>

    </div>
</nav>

<!-- SETTINGS MODAL -->
<div class="modal fade" id="settingsModal" tabindex="-1">
    <div class="modal-dialog modal-xl modal-dialog-centered">
        <div class="modal-content">

            <div class="modal-header">
                <h5><i class="fas fa-sliders-h"></i> Settings</h5>
                <button class="btn-close" data-bs-dismiss="modal"></button>
            </div>

            <div class="modal-body">

                <!-- TABS -->
                <ul class="nav nav-pills mb-3">
                    <li class="nav-item">
                        <a class="nav-link active tab-btn" data-tab="stateTab" href="#">State</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link tab-btn" data-tab="cityTab" href="#">City</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link tab-btn" data-tab="marketTab" href="#">Market</a>
                    </li>
                </ul>

                <!-- STATE TAB -->
                <div id="stateTab" class="tab-section">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="card p-3">
                                <h6>Add State</h6>
                                <input id="state_name" class="form-control" placeholder="State name">
                                <button onclick="addState()" class="btn btn-primary mt-2 w-100">Add State</button>
                            </div>
                        </div>

                        <div class="col-md-8">
                            <div class="card p-3 mt-3">
                                <h6>Existing States</h6>
                                <table class="table table-bordered">
                                    <thead>
                                        <tr><th>SR No.</th><th>State Name</th></tr>
                                    </thead>
                                    <tbody id="stateTable"></tbody>
                                </table>
                                
                            <div id="statePagination" class="mt-2 d-flex justify-content-center"></div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- CITY TAB -->
                <div id="cityTab" class="tab-section d-none">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="card p-3">
                                <h6>Add City</h6>
                                <select id="state_select" class="form-control mb-2"></select>
                                <input id="city_name" class="form-control" placeholder="City name">
                                <button onclick="addCity()" class="btn btn-success mt-2 w-100">Add City</button>
                            </div>
                        </div>

                        <div class="col-md-8">
                            <div class="card p-3 mt-3">
                                <h6>Existing Cities</h6>
                                <table class="table table-bordered">
                                    <thead>
                                        <tr><th>SR No.</th><th>City Name</th></tr>
                                    </thead>
                                    <tbody id="cityTable"></tbody>
                                </table>
                                <div id="cityPagination" class="mt-2 d-flex justify-content-center"></div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- MARKET TAB -->
                <div id="marketTab" class="tab-section d-none">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="card p-3">
                                <h6>Add Market</h6>
                                <select id="city_select" class="form-control mb-2"></select>
                                <input id="market_name" class="form-control" placeholder="Market name">
                                <button onclick="addMarket()" class="btn btn-warning mt-2 w-100">Add Market</button>
                            </div>
                        </div>

                        <div class="col-md-8">
                            <div class="card p-3">
                                <h6>Existing Markets</h6>
                                <table class="table table-bordered">
                                    <thead>
                                        <tr><th>SR No.</th><th>Market Name</th></tr>
                                    </thead>
                                    <tbody id="marketTable"></tbody>
                                </table>
                                <div id="marketPagination" class="mt-2 d-flex justify-content-center"></div>

                            </div>
                        </div>
                    </div>
                </div>

            </div>

            <div class="modal-footer">
                <button class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>

        </div>
    </div>
</div>