<div class="modal fade" id="opportunityModal">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            
            <div class="modal-header">
                <h5 class="modal-title">
                    <i class="fas fa-gem"></i>
                    Opportunity Details
                </h5>
                <button class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                
                <!-- TWO PART LAYOUT -->
                <div class="two-part-container">
                    
                    <!-- PART 1: INVENTORY -->
                    <div class="part-card part-1">
                        <div class="part-header">
                            <div class="part-number">1</div>
                            <h3 class="part-title">Inventory Information</h3>
                        </div>
                        
                        <!-- First Row - 6 Data Items -->
                        <div class="data-row">
                              
                             <div class="data-item">
                              <div class="data-label"><i class="fas fa-map-marker-alt"></i> RM Name - <div class="data-value" id="inv_rm_name">-</div></div>
                            </div>
                             <div class="data-item">
                                <div class="data-label"><i class="fas fa-map-marker-alt"></i> Property Type- <div class="data-value" id="inv_property_type">-</div></div>
                            </div>
                            <div class="data-item">
                                <div class="data-label"><i class="fas fa-map-marker-alt"></i> Unit Address- <div class="data-value" id="inv_unit">-</div></div>
                            </div>
                             <div class="data-item">
                                <div class="data-label"><i class="fas fa-map"></i> State- <div class="data-value" id="inv_state">-</div></div>
                            </div>
                              <div class="data-item">
                                <div class="data-label"><i class="fas fa-city"></i> City- <div class="data-value" id="inv_city">-</div></div>
                            </div>
                                <div class="data-item">
                                <div class="data-label"><i class="fas fa-store"></i> Market- <div class="data-value" id="inv_market">-</div></div>                            
                            </div>
                            <div class="data-item">
                                <div class="data-label"><i class="fas fa-ruler-combined"></i> Inventory Area- <div class="data-value" id="inv_area">-</div></div>
                            </div>
                             <div class="data-item">
                                <div class="data-label"><i class="fas fa-ruler-combined"></i> Inventory Rate- <div class="data-value" id="inv_rate">-</div></div>
                            </div>
                            <div class="data-item">
                                <div class="data-label"><i class="fas fa-rupee-sign"></i> Inventory Rent- <div class="data-value">₹ <span id="inv_rent">-</span></div></div>
                            </div>
                           
                           
                           
                        </div>
                        <!-- Second Row - 6 Data Items -->
                        <div class="data-row">
                           
                          <div class="data-item">
                                <div class="data-label"><i class="fas fa-user"></i> POC Name- <div class="data-value" id="inv_pocname">-</div></div>
                            </div>
                            <div class="data-item">
                                <div class="data-label"><i class="fas fa-briefcase"></i> Designation- <div class="data-value" id="inv_designation">-</div></div>
                            </div>
                            <div class="data-item">
                                <div class="data-label"><i class="fas fa-phone"></i> Mobile-  <div class="data-value" id="inv_mobile">-</div></div>
                            </div>
                            <div class="data-item">
                                <div class="data-label"><i class="fas fa-envelope"></i> Email- <div class="data-value" id="inv_email">-</div></div>
                            </div>
                            <div class="data-item">
                                <div class="data-label"><i class="fas fa-layer-group"></i> Floor-  <div class="data-value" id="inv_floor">-</div></div>
                            </div>
                            <div class="data-item">
                                <div class="data-label"><i class="fas fa-arrows-alt-h"></i> Frontage- <div class="data-value" id="inv_frontage">-</div></div>
                            </div>
                             
                        </div>
                        <!-- Third Row - 6 Data Items -->
                        <div class="data-row">
                           <div class="data-item">
                                <div class="data-label"><i class="fas fa-calendar-check"></i> Availability- <div class="data-value" id="inv_availability">-</div></div>
                            </div>
                            <div class="data-item">
                                <div class="data-label"><i class="fas fa-tag"></i> Current Tenant-<div class="data-value" id="inv_current_tenant">-</div></div>
                            </div>
                            <div class="data-item">
                                <div class="data-label"><i class="fas fa-calendar-times"></i> Vacant Date-  <div class="data-value" id="inv_vacant">-</div></div>
                            </div>
                           
                        </div>
                        <!-- IMAGE GALLERY SECTION -->
                         <div class="image-gallery">
        <div class="image-box">
            <img id="inv_frontimg" src="https://via.placeholder.com/400x300?text=Front+View">
            <div class="image-title">Front View</div>
        </div>
        <div class="image-box">
            <img id="inv_leftimg" src="https://via.placeholder.com/400x300?text=Left+View">
            <div class="image-title">Left View</div>
        </div>
        <div class="image-box">
            <img id="inv_rightimg" src="https://via.placeholder.com/400x300?text=Right+View">
            <div class="image-title">Right View</div>
        </div>
        <div class="image-box">
            <img id="inv_interiorimg" src="https://via.placeholder.com/400x300?text=Interior+View">
            <div class="image-title">Interior View</div>
        </div>
    </div>
                    </div>
                    <!-- PART 2: BRAND & REQUIREMENT -->
                    <div class="part-card part-2">
                        <div class="part-header">
                            <div class="part-number">2</div>
                            <h3 class="part-title">Brand & Requirement</h3>
                        </div>
                        
                        <!-- First Row - 6 Data Items -->
                        <div class="data-row">
                            <div class="data-item">
                                <div class="data-label"><i class="fas fa-trademark"></i> Brand Name- <div class="data-value" id="brand_name">-</div></div>
                            </div>
                            <div class="data-item">
    <div class="data-label">
        <i class="fas fa-store"></i> Store Type
    </div>
    <div class="data-value" id="brand_storetype">-</div>
</div>
<div class="data-item">
    <div class="data-label">
        <i class="fas fa-briefcase"></i> Business Model
    </div>
    <div class="data-value" id="brand_business_model">-</div>
</div>
                            <div class="data-item">
                                <div class="data-label"><i class="fas fa-industry"></i> Sector- <div class="data-value" id="brand_sector">-</div></div>
                            </div>
                            <div class="data-item">
                                <div class="data-label"><i class="fas fa-globe"></i> Website- <div class="data-value" id="brand_website">-</div></div>
                            </div>
                           <div class="data-item"><div class="data-label"><i class="fas fa-file-pdf"></i> Deck- <div class="data-value">  <a id="brand_deck"href="#"target="_blank"class="text-decoration-none fw-bold text-danger"> Not Available</a> </div> </div></div>

                        </div>
                        <!-- Second Row - 6 Data Items -->
                        <div class="data-row">
                            <div class="data-item">
                                <div class="data-label"><i class="fas fa-wallet"></i> Budget- <div class="data-value">₹ <span id="req_budget">-</span></div></div>
                                
                            </div>
                            <div class="data-item">
                                <div class="data-label"><i class="fas fa-expand"></i> Size- <div class="data-value" id="req_size">-</div></div>
                                
                            </div>
                            <div class="data-item">
                                <div class="data-label"><i class="fas fa-level-up-alt"></i> Floor- <div class="data-value" id="req_floor">-</div></div>
                                
                            </div>
                            <div class="data-item">
                                <div class="data-label"><i class="fas fa-map"></i> State- <div class="data-value" id="req_state">-</div></div>
                               
                            </div>
                            <div class="data-item">
                                <div class="data-label"><i class="fas fa-city"></i> City- <div class="data-value" id="req_city">-</div></div>
                                
                            </div>
                            <div class="data-item">
                                <div class="data-label"><i class="fas fa-store"></i> Market-  <div class="data-value" id="req_market">-</div></div>
                               
                            </div>
                        </div>
                        <!-- Third Row - 6 Data Items -->
                        <div class="data-row">
                            <div class="data-item">
                                <div class="data-label"><i class="fas fa-tag"></i> Type- <div class="data-value" id="req_type">-</div></div>
                                
                            </div>
                            <div class="data-item">
                                <div class="data-label"><i class="fas fa-clock"></i> Timeline-  <div class="data-value" id="req_timeline">-</div></div>
                               
                            </div>
                            <div class="data-item">
    <div class="data-label">
        <i class="fas fa-industry me-2"></i> Brand RM Name
    </div>
    <div class="data-value" id="brand_rm_name">-</div>
</div>

<div class="data-item">
    <div class="data-label">
        <i class="fas fa-arrows-alt-h"></i> Frontage Required
    </div>
    <div class="data-value" id="req_frontage">-</div>
</div>
                          



                               <!-- BRAND POC SECTION -->
                
                        <div class="data-item">
                            <div class="data-label"><i class="fas fa-user"></i> Brand Poc Name- <div class="data-value" id="brandpoc_name">-</div></div>
                            
                        </div>
                        <div class="data-item">
                            <div class="data-label"><i class="fas fa-briefcase"></i> Designation- <div class="data-value" id="brandpoc_designation">-</div></div>
                            
                        </div>
                        <div class="data-item">
                            <div class="data-label"><i class="fas fa-phone"></i> Phone-  <div class="data-value" id="brandpoc_phone">-</div></div>
                           
                        </div>
                        <div class="data-item">
                            <div class="data-label"><i class="fas fa-envelope"></i> Email- <div class="data-value" id="brandpoc_email">-</div></div>
                            
                        </div>
                        <div class="data-item">
                            <div class="data-label"><i class="fas fa-map-marked-alt"></i> Zone-  <div class="data-value" id="brandpoc_zone">-</div></div>
                           
                        </div>
                        <!--<div class="data-item">-->
                        <!--    <div class="data-label"><i class="fas fa-id-badge"></i> Department- <div class="data-value">Expansion</div></div>-->
                            
                        <!--</div>-->
                    </div>
                </div>
                        </div>
                  
                               
            </div>
        </div>
    </div>
</div>
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/js/bootstrap.bundle.min.js"></script>
<script>
    
function viewOpportunity(id) {
    fetch(`/opportunities/${id}`)
        .then(res => res.json())
        .then(data => {
            // INVENTORY
           document.getElementById('inv_rm_name').innerText = data.inventory?.rm_name ?? '-';
            document.getElementById('inv_property_type').innerText = data.inventory?.type ?? '-';
            document.getElementById('inv_unit').innerText = data.inventory?.unit_address ?? '-';
            document.getElementById('inv_area').innerText = data.inventory?.area ?? '-';
            document.getElementById('inv_rate').innerText = data.inventory?.rate ?? '-';
            document.getElementById('inv_rent').innerText = data.inventory?.monthly_rent ?? '-';
            document.getElementById('inv_state').innerText = data.inventory?.state?.name ?? '-';
            document.getElementById('inv_city').innerText = data.inventory?.city?.name ?? '-';
            document.getElementById('inv_market').innerText = data.inventory?.market?.name ?? '-';
            document.getElementById('inv_pocname').innerText = data.inventory?.poc_name ?? '-';
            document.getElementById('inv_designation').innerText = data.inventory?.designation ?? '-';
            document.getElementById('inv_mobile').innerText = data.inventory?.mobile ?? '-';
            document.getElementById('inv_email').innerText = data.inventory?.email ?? '-';
            document.getElementById('inv_floor').innerText = data.inventory?.floor ?? '-';
            document.getElementById('inv_frontage').innerText = data.inventory?.frontage ?? '-';
            document.getElementById('inv_availability').innerText = data.inventory?.availability ?? '-';
            document.getElementById('inv_current_tenant').innerText = data.inventory?.current_brand ?? '-';
            document.getElementById('inv_vacant').innerText = data.inventory?.vacant_date ?? '-';
            document.getElementById('inv_frontimg').src = data.inventory?.front_view ? '/storage/' + data.inventory.front_view : 'https://via.placeholder.com/400x300?text=Front+View';
            document.getElementById('inv_leftimg').src = data.inventory?.left_view ? '/storage/' + data.inventory.left_view : 'https://via.placeholder.com/400x300?text=Left+View';
            document.getElementById('inv_rightimg').src = data.inventory?.right_view ? '/storage/' + data.inventory.right_view : 'https://via.placeholder.com/400x300?text=Right+View';
            document.getElementById('inv_interiorimg').src = data.inventory?.interior_view ? '/storage/' + data.inventory.interior_view : 'https://via.placeholder.com/400x300?text=Interior+View';
            // BRAND
            document.getElementById('brand_name').innerText = data.requirement?.brand?.name ?? '-';
          // ✅ STORE TYPE
document.getElementById('brand_storetype').innerText =
    data.requirement?.brand?.brand_storetype ?? '-';
// ✅ BUSINESS MODEL
document.getElementById('brand_business_model').innerText =
    data.requirement?.brand?.business_model
        ? data.requirement.brand.business_model.split(',').join(' , ')
        : '-';
            document.getElementById('brand_sector').innerText = data.requirement?.brand?.sector ?? '-';
            document.getElementById('brand_website').innerText = data.requirement?.brand?.website ?? '-';
             /* ================= BRAND DECK PDF ================= */
            const deckEl = document.getElementById('brand_deck');
            const deckPath = data?.requirement?.brand?.deck;
            if (deckPath) {
                deckEl.href = `/storage/${deckPath}`;
                deckEl.innerHTML = '<i class="fas fa-file-pdf"></i> View PDF';
            } else {
                deckEl.removeAttribute('href');
                deckEl.innerText = 'Not Available';
            }
            // REQUIREMENT
            document.getElementById('req_budget').innerText = data.requirement?.budget ?? '-';
            document.getElementById('req_size').innerText = data.requirement?.size_range ?? '-';
            document.getElementById('req_floor').innerText = data.requirement?.floor_preference ?? '-';
            document.getElementById('req_state').innerText = data.requirement?.state?.name ?? '-';
            document.getElementById('req_city').innerText = data.requirement?.city?.name ?? '-';
            document.getElementById('req_market').innerText = data.requirement?.market?.name ?? '-';
            document.getElementById('req_type').innerText = data.requirement?.type ?? '-';
            document.getElementById('req_timeline').innerText = data.requirement?.timeline ?? '-';
            
            
            document.getElementById('req_frontage').innerText =
    data.requirement?.footage ?? '-';
            // BRAND POC
            document.getElementById('brandpoc_name').innerText = data.requirement?.poc?.name ?? '-';
            document.getElementById('brandpoc_designation').innerText = data.requirement?.poc?.designation ?? '-';
            document.getElementById('brandpoc_phone').innerText = data.requirement?.poc?.phone ?? '-';
            document.getElementById('brandpoc_email').innerText = data.requirement?.poc?.email ?? '-';
            document.getElementById('brand_rm_name').innerText =
    data.requirement?.brand?.brand_rm_name ?? '-';
            document.getElementById('brandpoc_zone').innerText = data.requirement?.poc?.zone ?? '-';
            new bootstrap.Modal(document.getElementById('opportunityModal')).show();
        });
}
// Demo function
function testModal() {
    document.getElementById('inv_unit').innerText = 'Shop No. 42, Phoenix Mall';
    document.getElementById('inv_area').innerText = '2500 sq ft';
    document.getElementById('inv_rent').innerText = '2,50,000';
    document.getElementById('inv_state').innerText = 'Maharashtra';
    document.getElementById('inv_city').innerText = 'Mumbai';
    document.getElementById('inv_market').innerText = 'Lower Parel';
    document.getElementById('brand_name').innerText = 'Starbucks Coffee';
    document.getElementById('brand_category').innerText = 'F&B';
    document.getElementById('req_budget').innerText = '3,00,000';
    
    new bootstrap.Modal(document.getElementById('opportunityModal')).show();
}




</script><?php /**PATH /home/ixapl/public_html/retailcrm.ixapl.com/resources/views/opportunities/modal.blade.php ENDPATH**/ ?>